/*
 * Decompiled with CFR 0.152.
 */
package util;

import androidx.compose.runtime.internal.StabilityInferred;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0001J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0001J'\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0014\u001a\u0002H\u0015\"\u0006\b\u0000\u0010\u0015\u0018\u00012\u0006\u0010\u0010\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00150\r\"\u0006\b\u0000\u0010\u0015\u0018\u00012\u0006\u0010\u0010\u001a\u00020\u000bH\u0086\bJ-\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\u001c\"\u0006\b\u0000\u0010\u001d\u0018\u0001\"\u0006\b\u0001\u0010\u001e\u0018\u00012\u0006\u0010\u0010\u001a\u00020\u000bH\u0086\bJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u000bJ\u0012\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\"\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006*"}, d2={"Lutil/YAML;", "", "<init>", "()V", "yamlMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getYamlMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "effectMapper", "getEffectMapper", "effectsToYaml", "", "effects", "", "LEffect;", "yamlToEffects", "yamlString", "objectToYaml2", "any", "objectToYaml", "yamlToObject", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;)Ljava/lang/Object;", "yamlToObjectList", "yamlToObjectMap", "", "K", "V", "extractYAML", "text", "tryExtractWithMarkers", "tryExtractWithRegex", "tryExtractHeuristic", "extractBetweenMarkers", "startMarker", "endMarker", "isValidYAML", "", "content", "app.red-mycelium.com"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nYAML.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAML.kt\nutil/YAML\n*L\n1#1,175:1\n61#1:176\n*S KotlinDebug\n*F\n+ 1 YAML.kt\nutil/YAML\n*L\n168#1:176\n*E\n"})
public final class YAML {
    @NotNull
    public static final YAML INSTANCE = new YAML();
    @NotNull
    private static final ObjectMapper yamlMapper;
    @NotNull
    private static final ObjectMapper effectMapper;
    public static final int $stable;

    private YAML() {
    }

    @NotNull
    public final ObjectMapper getYamlMapper() {
        return yamlMapper;
    }

    @NotNull
    public final ObjectMapper getEffectMapper() {
        return effectMapper;
    }

    @NotNull
    public final String effectsToYaml(@NotNull List<? extends Effect> effects) {
        Intrinsics.checkNotNullParameter(effects, "effects");
        String string = effectMapper.writeValueAsString(effects);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    @NotNull
    public final List<Effect> yamlToEffects(@NotNull String yamlString) {
        Intrinsics.checkNotNullParameter(yamlString, "yamlString");
        Object t = effectMapper.readValue(yamlString, (JavaType)effectMapper.getTypeFactory().constructCollectionType(List.class, Effect.class));
        Intrinsics.checkNotNullExpressionValue(t, "readValue(...)");
        return (List)t;
    }

    @NotNull
    public final String objectToYaml2(@NotNull Object any2) {
        Intrinsics.checkNotNullParameter(any2, "any");
        String string = yamlMapper.writeValueAsString(any2);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    @NotNull
    public final String objectToYaml(@NotNull Object any2) {
        ObjectMapper objectMapper;
        YAMLFactory yAMLFactory;
        Intrinsics.checkNotNullParameter(any2, "any");
        YAMLFactory $this$objectToYaml_u24lambda_u243 = yAMLFactory = new YAMLFactory();
        boolean bl = false;
        $this$objectToYaml_u24lambda_u243.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        $this$objectToYaml_u24lambda_u243.enable(YAMLGenerator.Feature.INDENT_ARRAYS);
        YAMLFactory factory2 = yAMLFactory;
        ObjectMapper $this$objectToYaml_u24lambda_u244 = objectMapper = new ObjectMapper(factory2);
        boolean bl2 = false;
        ExtensionsKt.registerKotlinModule($this$objectToYaml_u24lambda_u244);
        $this$objectToYaml_u24lambda_u244.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        $this$objectToYaml_u24lambda_u244.configure(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES, false);
        ObjectMapper prettyMapper = objectMapper;
        String string = prettyMapper.writeValueAsString(any2);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    public final <T> T yamlToObject(@NotNull String yamlString, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(yamlString, "yamlString");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return yamlMapper.readValue(yamlString, clazz);
    }

    public final /* synthetic */ <T> T yamlToObject(String yamlString) {
        Intrinsics.checkNotNullParameter(yamlString, "yamlString");
        boolean $i$f$yamlToObject = false;
        ObjectMapper objectMapper = this.getYamlMapper();
        Intrinsics.reifiedOperationMarker(4, "T");
        return (T)objectMapper.readValue(yamlString, Object.class);
    }

    public final /* synthetic */ <T> List<T> yamlToObjectList(String yamlString) {
        Intrinsics.checkNotNullParameter(yamlString, "yamlString");
        boolean $i$f$yamlToObjectList = false;
        ObjectMapper objectMapper = this.getYamlMapper();
        TypeFactory typeFactory = this.getYamlMapper().getTypeFactory();
        Intrinsics.reifiedOperationMarker(4, "T");
        Object t = objectMapper.readValue(yamlString, (JavaType)typeFactory.constructCollectionType(List.class, Object.class));
        Intrinsics.checkNotNullExpressionValue(t, "readValue(...)");
        return (List)t;
    }

    public final /* synthetic */ <K, V> Map<K, V> yamlToObjectMap(String yamlString) {
        Intrinsics.checkNotNullParameter(yamlString, "yamlString");
        boolean $i$f$yamlToObjectMap = false;
        ObjectMapper objectMapper = this.getYamlMapper();
        TypeFactory typeFactory = this.getYamlMapper().getTypeFactory();
        Intrinsics.reifiedOperationMarker(4, "K");
        Intrinsics.reifiedOperationMarker(4, "V");
        Object t = objectMapper.readValue(yamlString, (JavaType)typeFactory.constructMapType(Map.class, Object.class, Object.class));
        Intrinsics.checkNotNullExpressionValue(t, "readValue(...)");
        return (Map)t;
    }

    @Nullable
    public final String extractYAML(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        String string = this.tryExtractWithMarkers(text2);
        if (string == null && (string = this.tryExtractWithRegex(text2)) == null) {
            string = this.tryExtractHeuristic(text2);
        }
        return string;
    }

    private final String tryExtractWithMarkers(String text2) {
        Pair[] pairArray = new Pair[]{new Pair<String, String>("```yaml", "```"), new Pair<String, String>("```yml", "```"), new Pair<String, String>("```", "```"), new Pair<String, String>("---", "---")};
        List<Pair> markers = CollectionsKt.listOf(pairArray);
        for (Pair pair : markers) {
            String end2;
            String start2 = (String)pair.component1();
            String result2 = this.extractBetweenMarkers(text2, start2, end2 = (String)pair.component2());
            if (result2 == null || !this.isValidYAML(result2)) continue;
            return result2;
        }
        return null;
    }

    private final String tryExtractWithRegex(String text2) {
        Regex[] regexArray = new Regex[]{new Regex("```yaml\\s*(.*?)\\s*```", RegexOption.DOT_MATCHES_ALL), new Regex("```yml\\s*(.*?)\\s*```", RegexOption.DOT_MATCHES_ALL), new Regex("```\\s*(.*?)\\s*```", RegexOption.DOT_MATCHES_ALL), new Regex("---\\s*(.*?)\\s*---", RegexOption.DOT_MATCHES_ALL)};
        List<Regex> patterns = CollectionsKt.listOf(regexArray);
        for (Regex pattern : patterns) {
            MatchResult match = Regex.find$default(pattern, text2, 0, 2, null);
            Object object = match;
            if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = ((MatchGroup)object).getValue()) == null) continue;
            Object content = object;
            boolean bl = false;
            if (!INSTANCE.isValidYAML((String)content)) continue;
            return content;
        }
        return null;
    }

    private final String tryExtractHeuristic(String text2) {
        String candidate;
        List<String> lines = StringsKt.lines(text2);
        List yamlLines = new ArrayList();
        boolean inYamlBlock = false;
        int yamlLineCount = 0;
        for (String line : lines) {
            String candidate2;
            boolean looksLikeYAML;
            String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
            CharSequence charSequence = trimmed;
            boolean bl = looksLikeYAML = new Regex(".*:\\s*.+").matches(charSequence) || new Regex("-\\s*.+").matches(charSequence = (CharSequence)trimmed) || new Regex(".*:").matches(charSequence = (CharSequence)trimmed);
            if (looksLikeYAML) {
                yamlLines.add(line);
                ++yamlLineCount;
                inYamlBlock = true;
                continue;
            }
            if (!inYamlBlock) continue;
            if (yamlLineCount >= 2 && this.isValidYAML(candidate2 = CollectionsKt.joinToString$default(yamlLines, "\n", null, null, 0, null, null, 62, null))) {
                return candidate2;
            }
            yamlLines.clear();
            inYamlBlock = false;
            yamlLineCount = 0;
        }
        if (yamlLineCount >= 2 && this.isValidYAML(candidate = CollectionsKt.joinToString$default(yamlLines, "\n", null, null, 0, null, null, 62, null))) {
            return candidate;
        }
        return null;
    }

    private final String extractBetweenMarkers(String text2, String startMarker, String endMarker) {
        int startIndex = StringsKt.indexOf$default((CharSequence)text2, startMarker, 0, false, 6, null);
        if (startIndex == -1) {
            return null;
        }
        int contentStart = startIndex + startMarker.length();
        int endIndex = StringsKt.indexOf$default((CharSequence)text2, endMarker, contentStart, false, 4, null);
        if (endIndex == -1) {
            return null;
        }
        String string = text2.substring(contentStart, endIndex);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private final boolean isValidYAML(String content) {
        boolean bl;
        try {
            YAML this_$iv = INSTANCE;
            boolean $i$f$yamlToObject = false;
            this_$iv.getYamlMapper().readValue(content, Object.class);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    static {
        Versioned versioned = new ObjectMapper(new YAMLFactory());
        ObjectMapper $this$yamlMapper_u24lambda_u240 = versioned;
        boolean bl = false;
        ExtensionsKt.registerKotlinModule($this$yamlMapper_u24lambda_u240);
        $this$yamlMapper_u24lambda_u240.setDefaultMergeable(true);
        $this$yamlMapper_u24lambda_u240.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        $this$yamlMapper_u24lambda_u240.disable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES);
        $this$yamlMapper_u24lambda_u240.enable(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY);
        yamlMapper = versioned;
        Versioned $this$effectMapper_u24lambda_u241 = versioned = new YAMLFactory();
        boolean bl2 = false;
        ((YAMLFactory)$this$effectMapper_u24lambda_u241).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        ((YAMLFactory)$this$effectMapper_u24lambda_u241).enable(YAMLGenerator.Feature.INDENT_ARRAYS);
        JsonFactory jsonFactory = (JsonFactory)versioned;
        Versioned $this$effectMapper_u24lambda_u242 = versioned = new ObjectMapper(jsonFactory);
        boolean bl3 = false;
        ExtensionsKt.registerKotlinModule((ObjectMapper)$this$effectMapper_u24lambda_u242);
        ((ObjectMapper)$this$effectMapper_u24lambda_u242).enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        ((ObjectMapper)$this$effectMapper_u24lambda_u242).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        effectMapper = versioned;
        $stable = 8;
    }
}

