/*
 * Decompiled with CFR 0.152.
 */
package util;

import arhitecture.Scene;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a6\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u001a$\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u00a8\u0006\u0011"}, d2={"findSceneIndexByMovieTime", "", "timeMs", "allScenes", "", "Larhitecture/Scene;", "isRoundToLess", "", "movieTimeToSceneTime", "Lkotlin/Pair;", "targetScene", "sceneTimeToMovieTime", "scene", "formatTime", "", "milliseconds", "formatDuration", "app.red-mycelium.com"})
@SourceDebugExtension(value={"SMAP\nTimeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeUtil.kt\nutil/TimeUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1872#2,3:70\n1872#2,3:73\n1557#2:76\n1628#2,3:77\n*S KotlinDebug\n*F\n+ 1 TimeUtil.kt\nutil/TimeUtilKt\n*L\n12#1:70,3\n34#1:73,3\n50#1:76\n50#1:77,3\n*E\n"})
public final class TimeUtilKt {
    /*
     * WARNING - void declaration
     */
    public static final int findSceneIndexByMovieTime(int timeMs, @NotNull List<Scene> allScenes, boolean isRoundToLess) {
        Intrinsics.checkNotNullParameter(allScenes, "allScenes");
        int totalTime = 0;
        Iterable $this$forEachIndexed$iv = allScenes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void scene2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Scene scene3 = (Scene)item$iv;
            int index2 = n;
            boolean bl = false;
            if (isRoundToLess ? timeMs > totalTime && timeMs <= totalTime + scene2.getDurationMs() : timeMs >= totalTime && timeMs < totalTime + scene2.getDurationMs()) {
                return index2;
            }
            totalTime += scene2.getDurationMs();
        }
        if (timeMs >= totalTime) {
            return allScenes.size() - 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Pair<Scene, Integer> movieTimeToSceneTime(int timeMs, @NotNull List<Scene> allScenes, @Nullable Scene targetScene) {
        Intrinsics.checkNotNullParameter(allScenes, "allScenes");
        int totalTime = 0;
        Iterable $this$forEachIndexed$iv = allScenes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void scene2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Scene scene3 = (Scene)item$iv;
            int index2 = n;
            boolean bl = false;
            if (targetScene != null && scene2.getUniqId() != targetScene.getUniqId()) {
                totalTime += scene2.getDurationMs();
                continue;
            }
            if (timeMs >= totalTime && timeMs <= totalTime + scene2.getDurationMs()) {
                return new Pair<void, Integer>(scene2, timeMs - totalTime);
            }
            totalTime += scene2.getDurationMs();
        }
        return null;
    }

    public static /* synthetic */ Pair movieTimeToSceneTime$default(int n, List list2, Scene scene2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            scene2 = null;
        }
        return TimeUtilKt.movieTimeToSceneTime(n, list2, scene2);
    }

    /*
     * WARNING - void declaration
     */
    public static final int sceneTimeToMovieTime(int timeMs, @NotNull Scene scene2, @NotNull List<Scene> allScenes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scene2, "scene");
        Intrinsics.checkNotNullParameter(allScenes, "allScenes");
        Iterable $this$map$iv = allScenes.subList(0, allScenes.indexOf(scene2));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Scene scene3 = (Scene)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDurationMs());
        }
        return CollectionsKt.sumOfInt((List)destination$iv$iv) + timeMs;
    }

    @NotNull
    public static final String formatTime(int milliseconds) {
        int totalSeconds = milliseconds / 1000;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        String string = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, seconds};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public static final String formatDuration(int milliseconds) {
        int totalSeconds = milliseconds / 1000;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        int ms = milliseconds % 1000;
        String string = "%02d:%02d.%03d";
        Object[] objectArray = new Object[]{minutes, seconds, ms};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }
}

