/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0001\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u000e\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001e\u0010\u001c\u001a\u0002H\u001d\"\u0006\b\u0000\u0010\u001d\u0018\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u001f\u001a\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0001\u001a$\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u001e\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u0001\u001a,\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0002\"\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"jsonObjectToXml", "", "jsonObject", "Lcom/google/gson/JsonObject;", "gsonJsonArrayToXml", "jsonArray", "Lcom/google/gson/JsonArray;", "rootElementName", "convertGsonToJackson", "Lcom/fasterxml/jackson/databind/JsonNode;", "gsonElement", "Lcom/google/gson/JsonElement;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "xmlToJson", "xmlString", "xmlToGsonJsonObject", "xmlToJsonArray", "extractXmlWithRegex", "text", "extractAllXmlWithRegex", "", "xmlMapper", "getXmlMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectToXml", "obj", "", "xmlToObject", "T", "xml", "(Ljava/lang/String;)Ljava/lang/Object;", "removeChapterBranch", "Lkotlinx/serialization/json/JsonObject;", "chapters", "chapterId", "removeChapterRecursive", "", "Lkotlinx/serialization/json/JsonElement;", "current", "targetId", "addChapterBranch", "parentChaptId", "newChapterId", "addChapterRecursive", "newId", "app.red-mycelium.com"})
@SourceDebugExtension(value={"SMAP\nJson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Json.kt\nutil/JsonKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1863#2,2:311\n1863#2,2:313\n*S KotlinDebug\n*F\n+ 1 Json.kt\nutil/JsonKt\n*L\n84#1:311,2\n102#1:313,2\n*E\n"})
public final class JsonKt {
    @NotNull
    private static final ObjectMapper xmlMapper = ExtensionsKt.registerKotlinModule(new XmlMapper());

    @NotNull
    public static final String jsonObjectToXml(@NotNull com.google.gson.JsonObject jsonObject) {
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String jsonString = string;
        ObjectMapper objectMapper = new ObjectMapper();
        XmlMapper xmlMapper = new XmlMapper();
        JsonNode jsonNode = objectMapper.readTree(jsonString);
        Intrinsics.checkNotNullExpressionValue(jsonNode, "readTree(...)");
        JsonNode jsonNode2 = jsonNode;
        String string2 = xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonNode2);
        Intrinsics.checkNotNullExpressionValue(string2, "writeValueAsString(...)");
        return string2;
    }

    @NotNull
    public static final String gsonJsonArrayToXml(@NotNull JsonArray jsonArray, @NotNull String rootElementName) {
        Intrinsics.checkNotNullParameter(jsonArray, "jsonArray");
        Intrinsics.checkNotNullParameter(rootElementName, "rootElementName");
        XmlMapper xmlMapper = new XmlMapper();
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
        Object jacksonNode = objectMapper.valueToTree(jsonArray);
        Map dataMap = new LinkedHashMap();
        dataMap.put(rootElementName, jacksonNode);
        String string = xmlMapper.writeValueAsString(dataMap);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    public static /* synthetic */ String gsonJsonArrayToXml$default(JsonArray jsonArray, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "template";
        }
        return JsonKt.gsonJsonArrayToXml(jsonArray, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonNode convertGsonToJackson(com.google.gson.JsonElement gsonElement, ObjectMapper objectMapper) {
        Object object;
        if (gsonElement.isJsonObject()) {
            ObjectNode jacksonObject = objectMapper.createObjectNode();
            Set<Map.Entry<String, com.google.gson.JsonElement>> set = gsonElement.getAsJsonObject().entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "entrySet(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(entry);
                String key = (String)entry.getKey();
                com.google.gson.JsonElement value = (com.google.gson.JsonElement)entry.getValue();
                if (value.isJsonPrimitive()) {
                    jacksonObject.put(key, value.getAsString());
                    continue;
                }
                if (value.isJsonObject()) {
                    Intrinsics.checkNotNull(value);
                    JsonNode nestedObject = JsonKt.convertGsonToJackson(value, objectMapper);
                    jacksonObject.set(key, nestedObject);
                    continue;
                }
                if (value.isJsonArray()) {
                    Intrinsics.checkNotNull(value);
                    JsonNode jsonNode = JsonKt.convertGsonToJackson(value, objectMapper);
                    Intrinsics.checkNotNull(jsonNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
                    ArrayNode nestedArray = (ArrayNode)jsonNode;
                    jacksonObject.set(key, nestedArray);
                    continue;
                }
                if (!value.isJsonNull()) continue;
                jacksonObject.putNull(key);
            }
            ObjectNode objectNode = jacksonObject;
            Intrinsics.checkNotNull(objectNode);
            object = objectNode;
        } else if (gsonElement.isJsonArray()) {
            void var3_3;
            ArrayNode jacksonArray = objectMapper.createArrayNode();
            JsonArray jsonArray = gsonElement.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue(jsonArray, "getAsJsonArray(...)");
            Iterable $this$forEach$iv = jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                com.google.gson.JsonElement item2 = (com.google.gson.JsonElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(item2);
                JsonNode convertedItem = JsonKt.convertGsonToJackson(item2, objectMapper);
                jacksonArray.add(convertedItem);
            }
            void var2_21 = var3_3;
            Intrinsics.checkNotNull(var2_21);
            object = (JsonNode)var2_21;
        } else if (gsonElement.isJsonPrimitive()) {
            Object t = objectMapper.valueToTree(gsonElement.getAsString());
            Intrinsics.checkNotNull(t);
            object = t;
        } else {
            Object t = objectMapper.valueToTree(gsonElement.toString());
            Intrinsics.checkNotNull(t);
            object = t;
        }
        return object;
    }

    @NotNull
    public static final String xmlToJson(@NotNull String xmlString) {
        Intrinsics.checkNotNullParameter(xmlString, "xmlString");
        XmlMapper xmlMapper = new XmlMapper();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = xmlMapper.readTree(xmlString);
        Intrinsics.checkNotNullExpressionValue(jsonNode, "readTree(...)");
        JsonNode jsonNode2 = jsonNode;
        String string = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonNode2);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    @NotNull
    public static final com.google.gson.JsonObject xmlToGsonJsonObject(@NotNull String xmlString) {
        Intrinsics.checkNotNullParameter(xmlString, "xmlString");
        XmlMapper xmlMapper = new XmlMapper();
        JsonNode jsonNode = xmlMapper.readTree(xmlString);
        Intrinsics.checkNotNullExpressionValue(jsonNode, "readTree(...)");
        JsonNode jsonNode2 = jsonNode;
        String string = jsonNode2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String jsonString = string;
        com.google.gson.JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue(jsonObject, "getAsJsonObject(...)");
        return jsonObject;
    }

    @NotNull
    public static final JsonArray xmlToJsonArray(@NotNull String xmlString) {
        Intrinsics.checkNotNullParameter(xmlString, "xmlString");
        XmlMapper xmlMapper = new XmlMapper();
        JsonNode jsonNode = xmlMapper.readTree(xmlString);
        Intrinsics.checkNotNullExpressionValue(jsonNode, "readTree(...)");
        JsonNode jsonNode2 = jsonNode;
        String string = jsonNode2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String jsonString = string;
        com.google.gson.JsonElement parsed = JsonParser.parseString(jsonString);
        if (parsed instanceof JsonArray) {
            return (JsonArray)parsed;
        }
        Intrinsics.checkNotNull(parsed, "null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonArray jsonArray = ((com.google.gson.JsonObject)parsed).getAsJsonArray("root");
        Intrinsics.checkNotNullExpressionValue(jsonArray, "getAsJsonArray(...)");
        return jsonArray;
    }

    @Nullable
    public static final String extractXmlWithRegex(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Regex regex = new Regex("<(\\w+)[^>]*>(.*?)</\\1>", RegexOption.DOT_MATCHES_ALL);
        MatchResult matchResult = Regex.find$default(regex, text2, 0, 2, null);
        return matchResult != null ? matchResult.getValue() : null;
    }

    @NotNull
    public static final List<String> extractAllXmlWithRegex(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Regex regex = new Regex("<[^>]+>[^<]*</[^>]+>");
        return SequencesKt.toList(SequencesKt.map(Regex.findAll$default(regex, text2, 0, 2, null), JsonKt::extractAllXmlWithRegex$lambda$2));
    }

    @NotNull
    public static final ObjectMapper getXmlMapper() {
        return xmlMapper;
    }

    @NotNull
    public static final String objectToXml(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        String string = xmlMapper.writeValueAsString(obj);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    public static final /* synthetic */ <T> T xmlToObject(String xml) {
        Intrinsics.checkNotNullParameter(xml, "xml");
        boolean $i$f$xmlToObject = false;
        ObjectMapper objectMapper = JsonKt.getXmlMapper();
        Intrinsics.reifiedOperationMarker(4, "T");
        return (T)objectMapper.readValue(xml, Object.class);
    }

    @NotNull
    public static final JsonObject removeChapterBranch(@NotNull JsonObject chapters, @NotNull String chapterId) {
        Intrinsics.checkNotNullParameter(chapters, "chapters");
        Intrinsics.checkNotNullParameter(chapterId, "chapterId");
        return new JsonObject(JsonKt.removeChapterRecursive(chapters, chapterId));
    }

    private static final Map<String, JsonElement> removeChapterRecursive(JsonObject current, String targetId) {
        Map result2 = new LinkedHashMap();
        for (Map.Entry entry : ((Map)current).entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual(key, targetId)) continue;
            if (value instanceof JsonObject && !((Map)((Object)value)).isEmpty()) {
                Map<String, JsonElement> processedChildren = JsonKt.removeChapterRecursive((JsonObject)value, targetId);
                result2.put(key, new JsonObject(processedChildren));
                continue;
            }
            result2.put(key, value);
        }
        return result2;
    }

    @NotNull
    public static final JsonObject addChapterBranch(@NotNull JsonObject chapters, @NotNull String parentChaptId, @NotNull String newChapterId) {
        Intrinsics.checkNotNullParameter(chapters, "chapters");
        Intrinsics.checkNotNullParameter(parentChaptId, "parentChaptId");
        Intrinsics.checkNotNullParameter(newChapterId, "newChapterId");
        return new JsonObject(JsonKt.addChapterRecursive(chapters, parentChaptId, newChapterId));
    }

    private static final Map<String, JsonElement> addChapterRecursive(JsonObject current, String targetId, String newId) {
        Map result2 = new LinkedHashMap();
        for (Map.Entry entry : ((Map)current).entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value instanceof JsonObject && !((Map)((Object)value)).isEmpty()) {
                Map<String, JsonElement> processedChildren = JsonKt.addChapterRecursive((JsonObject)value, targetId, newId);
                if (Intrinsics.areEqual(key, targetId)) {
                    result2.put(key, new JsonObject(MapsKt.plus(processedChildren, TuplesKt.to(newId, new JsonObject(MapsKt.emptyMap())))));
                    continue;
                }
                result2.put(key, new JsonObject(processedChildren));
                continue;
            }
            if (Intrinsics.areEqual(key, targetId)) {
                result2.put(key, new JsonObject(MapsKt.mapOf(TuplesKt.to(newId, new JsonObject(MapsKt.emptyMap())))));
                continue;
            }
            result2.put(key, value);
        }
        return result2;
    }

    private static final String extractAllXmlWithRegex$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getValue();
    }
}

