/*
 * Decompiled with CFR 0.152.
 */
package storage;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018J\u0006\u0010\u0019\u001a\u00020\u0010J\u0006\u0010\u001a\u001a\u00020\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lstorage/SqliteStorage;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "dbFile", "getDbFile", "()Ljava/lang/String;", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "connection$delegate", "Lkotlin/Lazy;", "initDatabase", "", "save", "key", "value", "load", "delete", "", "getAllKeys", "", "clear", "close", "app.red-mycelium.com"})
@StabilityInferred(parameters=0)
public final class SqliteStorage {
    @NotNull
    private final String dbFile;
    @NotNull
    private final Lazy connection$delegate;
    public static final int $stable = 8;

    public SqliteStorage(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.dbFile = ProjectConfig.INSTANCE.getFolder().getPath() + "/" + name + ".db";
        this.connection$delegate = LazyKt.lazy(() -> SqliteStorage.connection_delegate$lambda$1(this));
    }

    @NotNull
    public final String getDbFile() {
        return this.dbFile;
    }

    private final Connection getConnection() {
        Lazy lazy = this.connection$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (Connection)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initDatabase(Connection connection) {
        String createTableSQL = "CREATE TABLE IF NOT EXISTS storage (\n    storage_key TEXT PRIMARY KEY,\n    storage_value TEXT\n)";
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            boolean bl2 = stmt.execute(createTableSQL);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        String sql = "INSERT OR REPLACE INTO storage (storage_key, storage_value)\nVALUES (?, ?)";
        AutoCloseable autoCloseable = this.getConnection().prepareStatement(sql);
        Throwable throwable = null;
        try {
            PreparedStatement prepStmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            prepStmt.setString(1, key);
            prepStmt.setString(2, value);
            int n = prepStmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String load(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String sql = "SELECT storage_value FROM storage WHERE storage_key = ?";
        AutoCloseable autoCloseable = this.getConnection().prepareStatement(sql);
        Throwable throwable = null;
        try {
            PreparedStatement prepStmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            prepStmt.setString(1, key);
            ResultSet resultSet = prepStmt.executeQuery();
            String string = resultSet.next() ? resultSet.getString("storage_value") : null;
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delete(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String sql = "DELETE FROM storage WHERE storage_key = ?";
        AutoCloseable autoCloseable = this.getConnection().prepareStatement(sql);
        Throwable throwable = null;
        try {
            PreparedStatement prepStmt = (PreparedStatement)autoCloseable;
            boolean bl = false;
            prepStmt.setString(1, key);
            boolean bl2 = prepStmt.executeUpdate() > 0;
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> getAllKeys() {
        String sql = "SELECT storage_key FROM storage";
        List keys2 = new ArrayList();
        AutoCloseable autoCloseable = this.getConnection().createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = stmt.executeQuery(sql);
            Throwable throwable2 = null;
            try {
                ResultSet resultSet = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                while (resultSet.next()) {
                    String string = resultSet.getString("storage_key");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    keys2.add(string);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return keys2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        AutoCloseable autoCloseable = this.getConnection().createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            int n = stmt.executeUpdate("DELETE FROM storage");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public final void close() {
        this.getConnection().close();
    }

    private static final Connection connection_delegate$lambda$1(SqliteStorage this$0) {
        Connection connection;
        new File(ProjectConfig.INSTANCE.getFolder().getPath()).mkdirs();
        Connection it = connection = DriverManager.getConnection("jdbc:sqlite:" + this$0.dbFile);
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        this$0.initDatabase(it);
        return connection;
    }
}

