/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.error;

import java.io.Serializable;
import org.yaml.snakeyaml.scanner.Constant;

public final class Mark
implements Serializable {
    private final String name;
    private final int index;
    private final int line;
    private final int column;
    private final int[] buffer;
    private final int pointer;

    private static int[] toCodePoints(char[] str) {
        int[] codePoints2 = new int[Character.codePointCount(str, 0, str.length)];
        int i = 0;
        int c = 0;
        while (i < str.length) {
            int cp;
            codePoints2[c] = cp = Character.codePointAt(str, i);
            i += Character.charCount(cp);
            ++c;
        }
        return codePoints2;
    }

    public Mark(String name, int index2, int line, int column, char[] str, int pointer) {
        this(name, index2, line, column, Mark.toCodePoints(str), pointer);
    }

    public Mark(String name, int index2, int line, int column, int[] buffer, int pointer) {
        this.name = name;
        this.index = index2;
        this.line = line;
        this.column = column;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    private boolean isLineBreak(int c) {
        return Constant.NULL_OR_LINEBR.has(c);
    }

    public String get_snippet(int indent, int max_length) {
        int i;
        float half = (float)max_length / 2.0f - 1.0f;
        int start2 = this.pointer;
        String head = "";
        while (start2 > 0 && !this.isLineBreak(this.buffer[start2 - 1])) {
            if (!((float)(this.pointer - --start2) > half)) continue;
            head = " ... ";
            start2 += 5;
            break;
        }
        String tail = "";
        int end2 = this.pointer;
        while (end2 < this.buffer.length && !this.isLineBreak(this.buffer[end2])) {
            if (!((float)(++end2 - this.pointer) > half)) continue;
            tail = " ... ";
            end2 -= 5;
            break;
        }
        StringBuilder result2 = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            result2.append(" ");
        }
        result2.append(head);
        for (i = start2; i < end2; ++i) {
            result2.appendCodePoint(this.buffer[i]);
        }
        result2.append(tail);
        result2.append("\n");
        for (i = 0; i < indent + this.pointer - start2 + head.length(); ++i) {
            result2.append(" ");
        }
        result2.append("^");
        return result2.toString();
    }

    public String get_snippet() {
        return this.get_snippet(4, 75);
    }

    public String toString() {
        String snippet = this.get_snippet();
        String builder = " in " + this.name + ", line " + (this.line + 1) + ", column " + (this.column + 1) + ":\n" + snippet;
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getPointer() {
        return this.pointer;
    }
}

