/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ximgproc;

import org.opencv.calib3d.StereoMatcher;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.ximgproc.AdaptiveManifoldFilter;
import org.opencv.ximgproc.ContourFitting;
import org.opencv.ximgproc.DTFilter;
import org.opencv.ximgproc.DisparityWLSFilter;
import org.opencv.ximgproc.EdgeAwareInterpolator;
import org.opencv.ximgproc.EdgeBoxes;
import org.opencv.ximgproc.EdgeDrawing;
import org.opencv.ximgproc.FastBilateralSolverFilter;
import org.opencv.ximgproc.FastGlobalSmootherFilter;
import org.opencv.ximgproc.FastLineDetector;
import org.opencv.ximgproc.GraphSegmentation;
import org.opencv.ximgproc.GuidedFilter;
import org.opencv.ximgproc.RFFeatureGetter;
import org.opencv.ximgproc.RICInterpolator;
import org.opencv.ximgproc.ScanSegment;
import org.opencv.ximgproc.SelectiveSearchSegmentation;
import org.opencv.ximgproc.SelectiveSearchSegmentationStrategy;
import org.opencv.ximgproc.SelectiveSearchSegmentationStrategyColor;
import org.opencv.ximgproc.SelectiveSearchSegmentationStrategyFill;
import org.opencv.ximgproc.SelectiveSearchSegmentationStrategyMultiple;
import org.opencv.ximgproc.SelectiveSearchSegmentationStrategySize;
import org.opencv.ximgproc.SelectiveSearchSegmentationStrategyTexture;
import org.opencv.ximgproc.StructuredEdgeDetection;
import org.opencv.ximgproc.SuperpixelLSC;
import org.opencv.ximgproc.SuperpixelSEEDS;
import org.opencv.ximgproc.SuperpixelSLIC;

public class Ximgproc {
    public static final int ARO_0_45 = 0;
    public static final int ARO_45_90 = 1;
    public static final int ARO_90_135 = 2;
    public static final int ARO_315_0 = 3;
    public static final int ARO_315_45 = 4;
    public static final int ARO_45_135 = 5;
    public static final int ARO_315_135 = 6;
    public static final int ARO_CTR_HOR = 7;
    public static final int ARO_CTR_VER = 8;
    public static final int DTF_NC = 0;
    public static final int DTF_IC = 1;
    public static final int DTF_RF = 2;
    public static final int GUIDED_FILTER = 3;
    public static final int AM_FILTER = 4;
    public static final int HDO_RAW = 0;
    public static final int HDO_DESKEW = 1;
    public static final int FHT_MIN = 0;
    public static final int FHT_MAX = 1;
    public static final int FHT_ADD = 2;
    public static final int FHT_AVE = 3;
    public static final int BINARIZATION_NIBLACK = 0;
    public static final int BINARIZATION_SAUVOLA = 1;
    public static final int BINARIZATION_WOLF = 2;
    public static final int BINARIZATION_NICK = 3;
    public static final int SLIC = 100;
    public static final int SLICO = 101;
    public static final int MSLIC = 102;
    public static final int THINNING_ZHANGSUEN = 0;
    public static final int THINNING_GUOHALL = 1;
    public static final int WMF_EXP = 1;
    public static final int WMF_IV1 = 2;
    public static final int WMF_IV2 = 4;
    public static final int WMF_COS = 8;
    public static final int WMF_JAC = 16;
    public static final int WMF_OFF = 32;

    public static void niBlackThreshold(Mat _src, Mat _dst, double maxValue, int type2, int blockSize, double k, int binarizationMethod, double r) {
        Ximgproc.niBlackThreshold_0(_src.nativeObj, _dst.nativeObj, maxValue, type2, blockSize, k, binarizationMethod, r);
    }

    public static void niBlackThreshold(Mat _src, Mat _dst, double maxValue, int type2, int blockSize, double k, int binarizationMethod) {
        Ximgproc.niBlackThreshold_1(_src.nativeObj, _dst.nativeObj, maxValue, type2, blockSize, k, binarizationMethod);
    }

    public static void niBlackThreshold(Mat _src, Mat _dst, double maxValue, int type2, int blockSize, double k) {
        Ximgproc.niBlackThreshold_2(_src.nativeObj, _dst.nativeObj, maxValue, type2, blockSize, k);
    }

    public static void thinning(Mat src, Mat dst, int thinningType) {
        Ximgproc.thinning_0(src.nativeObj, dst.nativeObj, thinningType);
    }

    public static void thinning(Mat src, Mat dst) {
        Ximgproc.thinning_1(src.nativeObj, dst.nativeObj);
    }

    public static void anisotropicDiffusion(Mat src, Mat dst, float alpha2, float K, int niters) {
        Ximgproc.anisotropicDiffusion_0(src.nativeObj, dst.nativeObj, alpha2, K, niters);
    }

    public static void BrightEdges(Mat _original, Mat _edgeview, int contrast, int shortrange, int longrange) {
        Ximgproc.BrightEdges_0(_original.nativeObj, _edgeview.nativeObj, contrast, shortrange, longrange);
    }

    public static void BrightEdges(Mat _original, Mat _edgeview, int contrast, int shortrange) {
        Ximgproc.BrightEdges_1(_original.nativeObj, _edgeview.nativeObj, contrast, shortrange);
    }

    public static void BrightEdges(Mat _original, Mat _edgeview, int contrast) {
        Ximgproc.BrightEdges_2(_original.nativeObj, _edgeview.nativeObj, contrast);
    }

    public static void BrightEdges(Mat _original, Mat _edgeview) {
        Ximgproc.BrightEdges_3(_original.nativeObj, _edgeview.nativeObj);
    }

    public static void createQuaternionImage(Mat img, Mat qimg) {
        Ximgproc.createQuaternionImage_0(img.nativeObj, qimg.nativeObj);
    }

    public static void qconj(Mat qimg, Mat qcimg) {
        Ximgproc.qconj_0(qimg.nativeObj, qcimg.nativeObj);
    }

    public static void qunitary(Mat qimg, Mat qnimg) {
        Ximgproc.qunitary_0(qimg.nativeObj, qnimg.nativeObj);
    }

    public static void qmultiply(Mat src1, Mat src2, Mat dst) {
        Ximgproc.qmultiply_0(src1.nativeObj, src2.nativeObj, dst.nativeObj);
    }

    public static void qdft(Mat img, Mat qimg, int flags, boolean sideLeft) {
        Ximgproc.qdft_0(img.nativeObj, qimg.nativeObj, flags, sideLeft);
    }

    public static void colorMatchTemplate(Mat img, Mat templ, Mat result2) {
        Ximgproc.colorMatchTemplate_0(img.nativeObj, templ.nativeObj, result2.nativeObj);
    }

    public static void GradientDericheY(Mat op, Mat dst, double alpha2, double omega) {
        Ximgproc.GradientDericheY_0(op.nativeObj, dst.nativeObj, alpha2, omega);
    }

    public static void GradientDericheX(Mat op, Mat dst, double alpha2, double omega) {
        Ximgproc.GradientDericheX_0(op.nativeObj, dst.nativeObj, alpha2, omega);
    }

    public static DisparityWLSFilter createDisparityWLSFilter(StereoMatcher matcher_left) {
        return DisparityWLSFilter.__fromPtr__(Ximgproc.createDisparityWLSFilter_0(matcher_left.getNativeObjAddr()));
    }

    public static StereoMatcher createRightMatcher(StereoMatcher matcher_left) {
        return StereoMatcher.__fromPtr__(Ximgproc.createRightMatcher_0(matcher_left.getNativeObjAddr()));
    }

    public static DisparityWLSFilter createDisparityWLSFilterGeneric(boolean use_confidence) {
        return DisparityWLSFilter.__fromPtr__(Ximgproc.createDisparityWLSFilterGeneric_0(use_confidence));
    }

    public static int readGT(String src_path, Mat dst) {
        return Ximgproc.readGT_0(src_path, dst.nativeObj);
    }

    public static double computeMSE(Mat GT, Mat src, Rect ROI) {
        return Ximgproc.computeMSE_0(GT.nativeObj, src.nativeObj, ROI.x, ROI.y, ROI.width, ROI.height);
    }

    public static double computeBadPixelPercent(Mat GT, Mat src, Rect ROI, int thresh) {
        return Ximgproc.computeBadPixelPercent_0(GT.nativeObj, src.nativeObj, ROI.x, ROI.y, ROI.width, ROI.height, thresh);
    }

    public static double computeBadPixelPercent(Mat GT, Mat src, Rect ROI) {
        return Ximgproc.computeBadPixelPercent_1(GT.nativeObj, src.nativeObj, ROI.x, ROI.y, ROI.width, ROI.height);
    }

    public static void getDisparityVis(Mat src, Mat dst, double scale2) {
        Ximgproc.getDisparityVis_0(src.nativeObj, dst.nativeObj, scale2);
    }

    public static void getDisparityVis(Mat src, Mat dst) {
        Ximgproc.getDisparityVis_1(src.nativeObj, dst.nativeObj);
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag, float edgeMergeThr, float clusterMinMag, float maxAspectRatio, float minBoxArea, float gamma, float kappa) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_0(alpha2, beta, eta, minScore, maxBoxes, edgeMinMag, edgeMergeThr, clusterMinMag, maxAspectRatio, minBoxArea, gamma, kappa));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag, float edgeMergeThr, float clusterMinMag, float maxAspectRatio, float minBoxArea, float gamma) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_1(alpha2, beta, eta, minScore, maxBoxes, edgeMinMag, edgeMergeThr, clusterMinMag, maxAspectRatio, minBoxArea, gamma));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag, float edgeMergeThr, float clusterMinMag, float maxAspectRatio, float minBoxArea) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_2(alpha2, beta, eta, minScore, maxBoxes, edgeMinMag, edgeMergeThr, clusterMinMag, maxAspectRatio, minBoxArea));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag, float edgeMergeThr, float clusterMinMag, float maxAspectRatio) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_3(alpha2, beta, eta, minScore, maxBoxes, edgeMinMag, edgeMergeThr, clusterMinMag, maxAspectRatio));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag, float edgeMergeThr, float clusterMinMag) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_4(alpha2, beta, eta, minScore, maxBoxes, edgeMinMag, edgeMergeThr, clusterMinMag));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag, float edgeMergeThr) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_5(alpha2, beta, eta, minScore, maxBoxes, edgeMinMag, edgeMergeThr));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes, float edgeMinMag) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_6(alpha2, beta, eta, minScore, maxBoxes, edgeMinMag));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore, int maxBoxes) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_7(alpha2, beta, eta, minScore, maxBoxes));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta, float minScore) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_8(alpha2, beta, eta, minScore));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta, float eta) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_9(alpha2, beta, eta));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2, float beta) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_10(alpha2, beta));
    }

    public static EdgeBoxes createEdgeBoxes(float alpha2) {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_11(alpha2));
    }

    public static EdgeBoxes createEdgeBoxes() {
        return EdgeBoxes.__fromPtr__(Ximgproc.createEdgeBoxes_12());
    }

    public static void edgePreservingFilter(Mat src, Mat dst, int d, double threshold) {
        Ximgproc.edgePreservingFilter_0(src.nativeObj, dst.nativeObj, d, threshold);
    }

    public static EdgeDrawing createEdgeDrawing() {
        return EdgeDrawing.__fromPtr__(Ximgproc.createEdgeDrawing_0());
    }

    public static DTFilter createDTFilter(Mat guide, double sigmaSpatial, double sigmaColor, int mode, int numIters) {
        return DTFilter.__fromPtr__(Ximgproc.createDTFilter_0(guide.nativeObj, sigmaSpatial, sigmaColor, mode, numIters));
    }

    public static DTFilter createDTFilter(Mat guide, double sigmaSpatial, double sigmaColor, int mode) {
        return DTFilter.__fromPtr__(Ximgproc.createDTFilter_1(guide.nativeObj, sigmaSpatial, sigmaColor, mode));
    }

    public static DTFilter createDTFilter(Mat guide, double sigmaSpatial, double sigmaColor) {
        return DTFilter.__fromPtr__(Ximgproc.createDTFilter_2(guide.nativeObj, sigmaSpatial, sigmaColor));
    }

    public static void dtFilter(Mat guide, Mat src, Mat dst, double sigmaSpatial, double sigmaColor, int mode, int numIters) {
        Ximgproc.dtFilter_0(guide.nativeObj, src.nativeObj, dst.nativeObj, sigmaSpatial, sigmaColor, mode, numIters);
    }

    public static void dtFilter(Mat guide, Mat src, Mat dst, double sigmaSpatial, double sigmaColor, int mode) {
        Ximgproc.dtFilter_1(guide.nativeObj, src.nativeObj, dst.nativeObj, sigmaSpatial, sigmaColor, mode);
    }

    public static void dtFilter(Mat guide, Mat src, Mat dst, double sigmaSpatial, double sigmaColor) {
        Ximgproc.dtFilter_2(guide.nativeObj, src.nativeObj, dst.nativeObj, sigmaSpatial, sigmaColor);
    }

    public static GuidedFilter createGuidedFilter(Mat guide, int radius, double eps, double scale2) {
        return GuidedFilter.__fromPtr__(Ximgproc.createGuidedFilter_0(guide.nativeObj, radius, eps, scale2));
    }

    public static GuidedFilter createGuidedFilter(Mat guide, int radius, double eps) {
        return GuidedFilter.__fromPtr__(Ximgproc.createGuidedFilter_1(guide.nativeObj, radius, eps));
    }

    public static void guidedFilter(Mat guide, Mat src, Mat dst, int radius, double eps, int dDepth, double scale2) {
        Ximgproc.guidedFilter_0(guide.nativeObj, src.nativeObj, dst.nativeObj, radius, eps, dDepth, scale2);
    }

    public static void guidedFilter(Mat guide, Mat src, Mat dst, int radius, double eps, int dDepth) {
        Ximgproc.guidedFilter_1(guide.nativeObj, src.nativeObj, dst.nativeObj, radius, eps, dDepth);
    }

    public static void guidedFilter(Mat guide, Mat src, Mat dst, int radius, double eps) {
        Ximgproc.guidedFilter_2(guide.nativeObj, src.nativeObj, dst.nativeObj, radius, eps);
    }

    public static AdaptiveManifoldFilter createAMFilter(double sigma_s, double sigma_r, boolean adjust_outliers) {
        return AdaptiveManifoldFilter.__fromPtr__(Ximgproc.createAMFilter_0(sigma_s, sigma_r, adjust_outliers));
    }

    public static AdaptiveManifoldFilter createAMFilter(double sigma_s, double sigma_r) {
        return AdaptiveManifoldFilter.__fromPtr__(Ximgproc.createAMFilter_1(sigma_s, sigma_r));
    }

    public static void amFilter(Mat joint, Mat src, Mat dst, double sigma_s, double sigma_r, boolean adjust_outliers) {
        Ximgproc.amFilter_0(joint.nativeObj, src.nativeObj, dst.nativeObj, sigma_s, sigma_r, adjust_outliers);
    }

    public static void amFilter(Mat joint, Mat src, Mat dst, double sigma_s, double sigma_r) {
        Ximgproc.amFilter_1(joint.nativeObj, src.nativeObj, dst.nativeObj, sigma_s, sigma_r);
    }

    public static void jointBilateralFilter(Mat joint, Mat src, Mat dst, int d, double sigmaColor, double sigmaSpace, int borderType) {
        Ximgproc.jointBilateralFilter_0(joint.nativeObj, src.nativeObj, dst.nativeObj, d, sigmaColor, sigmaSpace, borderType);
    }

    public static void jointBilateralFilter(Mat joint, Mat src, Mat dst, int d, double sigmaColor, double sigmaSpace) {
        Ximgproc.jointBilateralFilter_1(joint.nativeObj, src.nativeObj, dst.nativeObj, d, sigmaColor, sigmaSpace);
    }

    public static void bilateralTextureFilter(Mat src, Mat dst, int fr, int numIter, double sigmaAlpha, double sigmaAvg) {
        Ximgproc.bilateralTextureFilter_0(src.nativeObj, dst.nativeObj, fr, numIter, sigmaAlpha, sigmaAvg);
    }

    public static void bilateralTextureFilter(Mat src, Mat dst, int fr, int numIter, double sigmaAlpha) {
        Ximgproc.bilateralTextureFilter_1(src.nativeObj, dst.nativeObj, fr, numIter, sigmaAlpha);
    }

    public static void bilateralTextureFilter(Mat src, Mat dst, int fr, int numIter) {
        Ximgproc.bilateralTextureFilter_2(src.nativeObj, dst.nativeObj, fr, numIter);
    }

    public static void bilateralTextureFilter(Mat src, Mat dst, int fr) {
        Ximgproc.bilateralTextureFilter_3(src.nativeObj, dst.nativeObj, fr);
    }

    public static void bilateralTextureFilter(Mat src, Mat dst) {
        Ximgproc.bilateralTextureFilter_4(src.nativeObj, dst.nativeObj);
    }

    public static void rollingGuidanceFilter(Mat src, Mat dst, int d, double sigmaColor, double sigmaSpace, int numOfIter, int borderType) {
        Ximgproc.rollingGuidanceFilter_0(src.nativeObj, dst.nativeObj, d, sigmaColor, sigmaSpace, numOfIter, borderType);
    }

    public static void rollingGuidanceFilter(Mat src, Mat dst, int d, double sigmaColor, double sigmaSpace, int numOfIter) {
        Ximgproc.rollingGuidanceFilter_1(src.nativeObj, dst.nativeObj, d, sigmaColor, sigmaSpace, numOfIter);
    }

    public static void rollingGuidanceFilter(Mat src, Mat dst, int d, double sigmaColor, double sigmaSpace) {
        Ximgproc.rollingGuidanceFilter_2(src.nativeObj, dst.nativeObj, d, sigmaColor, sigmaSpace);
    }

    public static void rollingGuidanceFilter(Mat src, Mat dst, int d, double sigmaColor) {
        Ximgproc.rollingGuidanceFilter_3(src.nativeObj, dst.nativeObj, d, sigmaColor);
    }

    public static void rollingGuidanceFilter(Mat src, Mat dst, int d) {
        Ximgproc.rollingGuidanceFilter_4(src.nativeObj, dst.nativeObj, d);
    }

    public static void rollingGuidanceFilter(Mat src, Mat dst) {
        Ximgproc.rollingGuidanceFilter_5(src.nativeObj, dst.nativeObj);
    }

    public static FastBilateralSolverFilter createFastBilateralSolverFilter(Mat guide, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda, int num_iter, double max_tol) {
        return FastBilateralSolverFilter.__fromPtr__(Ximgproc.createFastBilateralSolverFilter_0(guide.nativeObj, sigma_spatial, sigma_luma, sigma_chroma, lambda, num_iter, max_tol));
    }

    public static FastBilateralSolverFilter createFastBilateralSolverFilter(Mat guide, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda, int num_iter) {
        return FastBilateralSolverFilter.__fromPtr__(Ximgproc.createFastBilateralSolverFilter_1(guide.nativeObj, sigma_spatial, sigma_luma, sigma_chroma, lambda, num_iter));
    }

    public static FastBilateralSolverFilter createFastBilateralSolverFilter(Mat guide, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda) {
        return FastBilateralSolverFilter.__fromPtr__(Ximgproc.createFastBilateralSolverFilter_2(guide.nativeObj, sigma_spatial, sigma_luma, sigma_chroma, lambda));
    }

    public static FastBilateralSolverFilter createFastBilateralSolverFilter(Mat guide, double sigma_spatial, double sigma_luma, double sigma_chroma) {
        return FastBilateralSolverFilter.__fromPtr__(Ximgproc.createFastBilateralSolverFilter_3(guide.nativeObj, sigma_spatial, sigma_luma, sigma_chroma));
    }

    public static void fastBilateralSolverFilter(Mat guide, Mat src, Mat confidence, Mat dst, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda, int num_iter, double max_tol) {
        Ximgproc.fastBilateralSolverFilter_0(guide.nativeObj, src.nativeObj, confidence.nativeObj, dst.nativeObj, sigma_spatial, sigma_luma, sigma_chroma, lambda, num_iter, max_tol);
    }

    public static void fastBilateralSolverFilter(Mat guide, Mat src, Mat confidence, Mat dst, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda, int num_iter) {
        Ximgproc.fastBilateralSolverFilter_1(guide.nativeObj, src.nativeObj, confidence.nativeObj, dst.nativeObj, sigma_spatial, sigma_luma, sigma_chroma, lambda, num_iter);
    }

    public static void fastBilateralSolverFilter(Mat guide, Mat src, Mat confidence, Mat dst, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda) {
        Ximgproc.fastBilateralSolverFilter_2(guide.nativeObj, src.nativeObj, confidence.nativeObj, dst.nativeObj, sigma_spatial, sigma_luma, sigma_chroma, lambda);
    }

    public static void fastBilateralSolverFilter(Mat guide, Mat src, Mat confidence, Mat dst, double sigma_spatial, double sigma_luma, double sigma_chroma) {
        Ximgproc.fastBilateralSolverFilter_3(guide.nativeObj, src.nativeObj, confidence.nativeObj, dst.nativeObj, sigma_spatial, sigma_luma, sigma_chroma);
    }

    public static void fastBilateralSolverFilter(Mat guide, Mat src, Mat confidence, Mat dst, double sigma_spatial, double sigma_luma) {
        Ximgproc.fastBilateralSolverFilter_4(guide.nativeObj, src.nativeObj, confidence.nativeObj, dst.nativeObj, sigma_spatial, sigma_luma);
    }

    public static void fastBilateralSolverFilter(Mat guide, Mat src, Mat confidence, Mat dst, double sigma_spatial) {
        Ximgproc.fastBilateralSolverFilter_5(guide.nativeObj, src.nativeObj, confidence.nativeObj, dst.nativeObj, sigma_spatial);
    }

    public static void fastBilateralSolverFilter(Mat guide, Mat src, Mat confidence, Mat dst) {
        Ximgproc.fastBilateralSolverFilter_6(guide.nativeObj, src.nativeObj, confidence.nativeObj, dst.nativeObj);
    }

    public static FastGlobalSmootherFilter createFastGlobalSmootherFilter(Mat guide, double lambda, double sigma_color, double lambda_attenuation, int num_iter) {
        return FastGlobalSmootherFilter.__fromPtr__(Ximgproc.createFastGlobalSmootherFilter_0(guide.nativeObj, lambda, sigma_color, lambda_attenuation, num_iter));
    }

    public static FastGlobalSmootherFilter createFastGlobalSmootherFilter(Mat guide, double lambda, double sigma_color, double lambda_attenuation) {
        return FastGlobalSmootherFilter.__fromPtr__(Ximgproc.createFastGlobalSmootherFilter_1(guide.nativeObj, lambda, sigma_color, lambda_attenuation));
    }

    public static FastGlobalSmootherFilter createFastGlobalSmootherFilter(Mat guide, double lambda, double sigma_color) {
        return FastGlobalSmootherFilter.__fromPtr__(Ximgproc.createFastGlobalSmootherFilter_2(guide.nativeObj, lambda, sigma_color));
    }

    public static void fastGlobalSmootherFilter(Mat guide, Mat src, Mat dst, double lambda, double sigma_color, double lambda_attenuation, int num_iter) {
        Ximgproc.fastGlobalSmootherFilter_0(guide.nativeObj, src.nativeObj, dst.nativeObj, lambda, sigma_color, lambda_attenuation, num_iter);
    }

    public static void fastGlobalSmootherFilter(Mat guide, Mat src, Mat dst, double lambda, double sigma_color, double lambda_attenuation) {
        Ximgproc.fastGlobalSmootherFilter_1(guide.nativeObj, src.nativeObj, dst.nativeObj, lambda, sigma_color, lambda_attenuation);
    }

    public static void fastGlobalSmootherFilter(Mat guide, Mat src, Mat dst, double lambda, double sigma_color) {
        Ximgproc.fastGlobalSmootherFilter_2(guide.nativeObj, src.nativeObj, dst.nativeObj, lambda, sigma_color);
    }

    public static void l0Smooth(Mat src, Mat dst, double lambda, double kappa) {
        Ximgproc.l0Smooth_0(src.nativeObj, dst.nativeObj, lambda, kappa);
    }

    public static void l0Smooth(Mat src, Mat dst, double lambda) {
        Ximgproc.l0Smooth_1(src.nativeObj, dst.nativeObj, lambda);
    }

    public static void l0Smooth(Mat src, Mat dst) {
        Ximgproc.l0Smooth_2(src.nativeObj, dst.nativeObj);
    }

    public static void covarianceEstimation(Mat src, Mat dst, int windowRows, int windowCols) {
        Ximgproc.covarianceEstimation_0(src.nativeObj, dst.nativeObj, windowRows, windowCols);
    }

    public static void FastHoughTransform(Mat src, Mat dst, int dstMatDepth, int angleRange, int op, int makeSkew) {
        Ximgproc.FastHoughTransform_0(src.nativeObj, dst.nativeObj, dstMatDepth, angleRange, op, makeSkew);
    }

    public static void FastHoughTransform(Mat src, Mat dst, int dstMatDepth, int angleRange, int op) {
        Ximgproc.FastHoughTransform_1(src.nativeObj, dst.nativeObj, dstMatDepth, angleRange, op);
    }

    public static void FastHoughTransform(Mat src, Mat dst, int dstMatDepth, int angleRange) {
        Ximgproc.FastHoughTransform_2(src.nativeObj, dst.nativeObj, dstMatDepth, angleRange);
    }

    public static void FastHoughTransform(Mat src, Mat dst, int dstMatDepth) {
        Ximgproc.FastHoughTransform_3(src.nativeObj, dst.nativeObj, dstMatDepth);
    }

    public static FastLineDetector createFastLineDetector(int length_threshold, float distance_threshold, double canny_th1, double canny_th2, int canny_aperture_size, boolean do_merge) {
        return FastLineDetector.__fromPtr__(Ximgproc.createFastLineDetector_0(length_threshold, distance_threshold, canny_th1, canny_th2, canny_aperture_size, do_merge));
    }

    public static FastLineDetector createFastLineDetector(int length_threshold, float distance_threshold, double canny_th1, double canny_th2, int canny_aperture_size) {
        return FastLineDetector.__fromPtr__(Ximgproc.createFastLineDetector_1(length_threshold, distance_threshold, canny_th1, canny_th2, canny_aperture_size));
    }

    public static FastLineDetector createFastLineDetector(int length_threshold, float distance_threshold, double canny_th1, double canny_th2) {
        return FastLineDetector.__fromPtr__(Ximgproc.createFastLineDetector_2(length_threshold, distance_threshold, canny_th1, canny_th2));
    }

    public static FastLineDetector createFastLineDetector(int length_threshold, float distance_threshold, double canny_th1) {
        return FastLineDetector.__fromPtr__(Ximgproc.createFastLineDetector_3(length_threshold, distance_threshold, canny_th1));
    }

    public static FastLineDetector createFastLineDetector(int length_threshold, float distance_threshold) {
        return FastLineDetector.__fromPtr__(Ximgproc.createFastLineDetector_4(length_threshold, distance_threshold));
    }

    public static FastLineDetector createFastLineDetector(int length_threshold) {
        return FastLineDetector.__fromPtr__(Ximgproc.createFastLineDetector_5(length_threshold));
    }

    public static FastLineDetector createFastLineDetector() {
        return FastLineDetector.__fromPtr__(Ximgproc.createFastLineDetector_6());
    }

    public static void findEllipses(Mat image, Mat ellipses, float scoreThreshold, float reliabilityThreshold, float centerDistanceThreshold) {
        Ximgproc.findEllipses_0(image.nativeObj, ellipses.nativeObj, scoreThreshold, reliabilityThreshold, centerDistanceThreshold);
    }

    public static void findEllipses(Mat image, Mat ellipses, float scoreThreshold, float reliabilityThreshold) {
        Ximgproc.findEllipses_1(image.nativeObj, ellipses.nativeObj, scoreThreshold, reliabilityThreshold);
    }

    public static void findEllipses(Mat image, Mat ellipses, float scoreThreshold) {
        Ximgproc.findEllipses_2(image.nativeObj, ellipses.nativeObj, scoreThreshold);
    }

    public static void findEllipses(Mat image, Mat ellipses) {
        Ximgproc.findEllipses_3(image.nativeObj, ellipses.nativeObj);
    }

    public static void fourierDescriptor(Mat src, Mat dst, int nbElt, int nbFD) {
        Ximgproc.fourierDescriptor_0(src.nativeObj, dst.nativeObj, nbElt, nbFD);
    }

    public static void fourierDescriptor(Mat src, Mat dst, int nbElt) {
        Ximgproc.fourierDescriptor_1(src.nativeObj, dst.nativeObj, nbElt);
    }

    public static void fourierDescriptor(Mat src, Mat dst) {
        Ximgproc.fourierDescriptor_2(src.nativeObj, dst.nativeObj);
    }

    public static void transformFD(Mat src, Mat t, Mat dst, boolean fdContour) {
        Ximgproc.transformFD_0(src.nativeObj, t.nativeObj, dst.nativeObj, fdContour);
    }

    public static void transformFD(Mat src, Mat t, Mat dst) {
        Ximgproc.transformFD_1(src.nativeObj, t.nativeObj, dst.nativeObj);
    }

    public static void contourSampling(Mat src, Mat out, int nbElt) {
        Ximgproc.contourSampling_0(src.nativeObj, out.nativeObj, nbElt);
    }

    public static ContourFitting createContourFitting(int ctr, int fd) {
        return ContourFitting.__fromPtr__(Ximgproc.createContourFitting_0(ctr, fd));
    }

    public static ContourFitting createContourFitting(int ctr) {
        return ContourFitting.__fromPtr__(Ximgproc.createContourFitting_1(ctr));
    }

    public static ContourFitting createContourFitting() {
        return ContourFitting.__fromPtr__(Ximgproc.createContourFitting_2());
    }

    public static SuperpixelLSC createSuperpixelLSC(Mat image, int region_size, float ratio) {
        return SuperpixelLSC.__fromPtr__(Ximgproc.createSuperpixelLSC_0(image.nativeObj, region_size, ratio));
    }

    public static SuperpixelLSC createSuperpixelLSC(Mat image, int region_size) {
        return SuperpixelLSC.__fromPtr__(Ximgproc.createSuperpixelLSC_1(image.nativeObj, region_size));
    }

    public static SuperpixelLSC createSuperpixelLSC(Mat image) {
        return SuperpixelLSC.__fromPtr__(Ximgproc.createSuperpixelLSC_2(image.nativeObj));
    }

    public static void PeiLinNormalization(Mat I, Mat T) {
        Ximgproc.PeiLinNormalization_0(I.nativeObj, T.nativeObj);
    }

    public static void RadonTransform(Mat src, Mat dst, double theta, double start_angle, double end_angle, boolean crop, boolean norm) {
        Ximgproc.RadonTransform_0(src.nativeObj, dst.nativeObj, theta, start_angle, end_angle, crop, norm);
    }

    public static void RadonTransform(Mat src, Mat dst, double theta, double start_angle, double end_angle, boolean crop) {
        Ximgproc.RadonTransform_1(src.nativeObj, dst.nativeObj, theta, start_angle, end_angle, crop);
    }

    public static void RadonTransform(Mat src, Mat dst, double theta, double start_angle, double end_angle) {
        Ximgproc.RadonTransform_2(src.nativeObj, dst.nativeObj, theta, start_angle, end_angle);
    }

    public static void RadonTransform(Mat src, Mat dst, double theta, double start_angle) {
        Ximgproc.RadonTransform_3(src.nativeObj, dst.nativeObj, theta, start_angle);
    }

    public static void RadonTransform(Mat src, Mat dst, double theta) {
        Ximgproc.RadonTransform_4(src.nativeObj, dst.nativeObj, theta);
    }

    public static void RadonTransform(Mat src, Mat dst) {
        Ximgproc.RadonTransform_5(src.nativeObj, dst.nativeObj);
    }

    public static ScanSegment createScanSegment(int image_width, int image_height, int num_superpixels, int slices, boolean merge_small) {
        return ScanSegment.__fromPtr__(Ximgproc.createScanSegment_0(image_width, image_height, num_superpixels, slices, merge_small));
    }

    public static ScanSegment createScanSegment(int image_width, int image_height, int num_superpixels, int slices) {
        return ScanSegment.__fromPtr__(Ximgproc.createScanSegment_1(image_width, image_height, num_superpixels, slices));
    }

    public static ScanSegment createScanSegment(int image_width, int image_height, int num_superpixels) {
        return ScanSegment.__fromPtr__(Ximgproc.createScanSegment_2(image_width, image_height, num_superpixels));
    }

    public static SuperpixelSEEDS createSuperpixelSEEDS(int image_width, int image_height, int image_channels, int num_superpixels, int num_levels, int prior, int histogram_bins, boolean double_step) {
        return SuperpixelSEEDS.__fromPtr__(Ximgproc.createSuperpixelSEEDS_0(image_width, image_height, image_channels, num_superpixels, num_levels, prior, histogram_bins, double_step));
    }

    public static SuperpixelSEEDS createSuperpixelSEEDS(int image_width, int image_height, int image_channels, int num_superpixels, int num_levels, int prior, int histogram_bins) {
        return SuperpixelSEEDS.__fromPtr__(Ximgproc.createSuperpixelSEEDS_1(image_width, image_height, image_channels, num_superpixels, num_levels, prior, histogram_bins));
    }

    public static SuperpixelSEEDS createSuperpixelSEEDS(int image_width, int image_height, int image_channels, int num_superpixels, int num_levels, int prior) {
        return SuperpixelSEEDS.__fromPtr__(Ximgproc.createSuperpixelSEEDS_2(image_width, image_height, image_channels, num_superpixels, num_levels, prior));
    }

    public static SuperpixelSEEDS createSuperpixelSEEDS(int image_width, int image_height, int image_channels, int num_superpixels, int num_levels) {
        return SuperpixelSEEDS.__fromPtr__(Ximgproc.createSuperpixelSEEDS_3(image_width, image_height, image_channels, num_superpixels, num_levels));
    }

    public static GraphSegmentation createGraphSegmentation(double sigma, float k, int min_size) {
        return GraphSegmentation.__fromPtr__(Ximgproc.createGraphSegmentation_0(sigma, k, min_size));
    }

    public static GraphSegmentation createGraphSegmentation(double sigma, float k) {
        return GraphSegmentation.__fromPtr__(Ximgproc.createGraphSegmentation_1(sigma, k));
    }

    public static GraphSegmentation createGraphSegmentation(double sigma) {
        return GraphSegmentation.__fromPtr__(Ximgproc.createGraphSegmentation_2(sigma));
    }

    public static GraphSegmentation createGraphSegmentation() {
        return GraphSegmentation.__fromPtr__(Ximgproc.createGraphSegmentation_3());
    }

    public static SelectiveSearchSegmentationStrategyColor createSelectiveSearchSegmentationStrategyColor() {
        return SelectiveSearchSegmentationStrategyColor.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyColor_0());
    }

    public static SelectiveSearchSegmentationStrategySize createSelectiveSearchSegmentationStrategySize() {
        return SelectiveSearchSegmentationStrategySize.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategySize_0());
    }

    public static SelectiveSearchSegmentationStrategyTexture createSelectiveSearchSegmentationStrategyTexture() {
        return SelectiveSearchSegmentationStrategyTexture.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyTexture_0());
    }

    public static SelectiveSearchSegmentationStrategyFill createSelectiveSearchSegmentationStrategyFill() {
        return SelectiveSearchSegmentationStrategyFill.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyFill_0());
    }

    public static SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple() {
        return SelectiveSearchSegmentationStrategyMultiple.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyMultiple_0());
    }

    public static SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(SelectiveSearchSegmentationStrategy s1) {
        return SelectiveSearchSegmentationStrategyMultiple.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyMultiple_1(s1.getNativeObjAddr()));
    }

    public static SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(SelectiveSearchSegmentationStrategy s1, SelectiveSearchSegmentationStrategy s2) {
        return SelectiveSearchSegmentationStrategyMultiple.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyMultiple_2(s1.getNativeObjAddr(), s2.getNativeObjAddr()));
    }

    public static SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(SelectiveSearchSegmentationStrategy s1, SelectiveSearchSegmentationStrategy s2, SelectiveSearchSegmentationStrategy s3) {
        return SelectiveSearchSegmentationStrategyMultiple.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyMultiple_3(s1.getNativeObjAddr(), s2.getNativeObjAddr(), s3.getNativeObjAddr()));
    }

    public static SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(SelectiveSearchSegmentationStrategy s1, SelectiveSearchSegmentationStrategy s2, SelectiveSearchSegmentationStrategy s3, SelectiveSearchSegmentationStrategy s4) {
        return SelectiveSearchSegmentationStrategyMultiple.__fromPtr__(Ximgproc.createSelectiveSearchSegmentationStrategyMultiple_4(s1.getNativeObjAddr(), s2.getNativeObjAddr(), s3.getNativeObjAddr(), s4.getNativeObjAddr()));
    }

    public static SelectiveSearchSegmentation createSelectiveSearchSegmentation() {
        return SelectiveSearchSegmentation.__fromPtr__(Ximgproc.createSelectiveSearchSegmentation_0());
    }

    public static SuperpixelSLIC createSuperpixelSLIC(Mat image, int algorithm, int region_size, float ruler) {
        return SuperpixelSLIC.__fromPtr__(Ximgproc.createSuperpixelSLIC_0(image.nativeObj, algorithm, region_size, ruler));
    }

    public static SuperpixelSLIC createSuperpixelSLIC(Mat image, int algorithm, int region_size) {
        return SuperpixelSLIC.__fromPtr__(Ximgproc.createSuperpixelSLIC_1(image.nativeObj, algorithm, region_size));
    }

    public static SuperpixelSLIC createSuperpixelSLIC(Mat image, int algorithm) {
        return SuperpixelSLIC.__fromPtr__(Ximgproc.createSuperpixelSLIC_2(image.nativeObj, algorithm));
    }

    public static SuperpixelSLIC createSuperpixelSLIC(Mat image) {
        return SuperpixelSLIC.__fromPtr__(Ximgproc.createSuperpixelSLIC_3(image.nativeObj));
    }

    public static EdgeAwareInterpolator createEdgeAwareInterpolator() {
        return EdgeAwareInterpolator.__fromPtr__(Ximgproc.createEdgeAwareInterpolator_0());
    }

    public static RICInterpolator createRICInterpolator() {
        return RICInterpolator.__fromPtr__(Ximgproc.createRICInterpolator_0());
    }

    public static RFFeatureGetter createRFFeatureGetter() {
        return RFFeatureGetter.__fromPtr__(Ximgproc.createRFFeatureGetter_0());
    }

    public static StructuredEdgeDetection createStructuredEdgeDetection(String model, RFFeatureGetter howToGetFeatures) {
        return StructuredEdgeDetection.__fromPtr__(Ximgproc.createStructuredEdgeDetection_0(model, howToGetFeatures.getNativeObjAddr()));
    }

    public static StructuredEdgeDetection createStructuredEdgeDetection(String model) {
        return StructuredEdgeDetection.__fromPtr__(Ximgproc.createStructuredEdgeDetection_1(model));
    }

    public static void weightedMedianFilter(Mat joint, Mat src, Mat dst, int r, double sigma, int weightType, Mat mask) {
        Ximgproc.weightedMedianFilter_0(joint.nativeObj, src.nativeObj, dst.nativeObj, r, sigma, weightType, mask.nativeObj);
    }

    public static void weightedMedianFilter(Mat joint, Mat src, Mat dst, int r, double sigma, int weightType) {
        Ximgproc.weightedMedianFilter_1(joint.nativeObj, src.nativeObj, dst.nativeObj, r, sigma, weightType);
    }

    public static void weightedMedianFilter(Mat joint, Mat src, Mat dst, int r, double sigma) {
        Ximgproc.weightedMedianFilter_2(joint.nativeObj, src.nativeObj, dst.nativeObj, r, sigma);
    }

    public static void weightedMedianFilter(Mat joint, Mat src, Mat dst, int r) {
        Ximgproc.weightedMedianFilter_3(joint.nativeObj, src.nativeObj, dst.nativeObj, r);
    }

    private static native void niBlackThreshold_0(long var0, long var2, double var4, int var6, int var7, double var8, int var10, double var11);

    private static native void niBlackThreshold_1(long var0, long var2, double var4, int var6, int var7, double var8, int var10);

    private static native void niBlackThreshold_2(long var0, long var2, double var4, int var6, int var7, double var8);

    private static native void thinning_0(long var0, long var2, int var4);

    private static native void thinning_1(long var0, long var2);

    private static native void anisotropicDiffusion_0(long var0, long var2, float var4, float var5, int var6);

    private static native void BrightEdges_0(long var0, long var2, int var4, int var5, int var6);

    private static native void BrightEdges_1(long var0, long var2, int var4, int var5);

    private static native void BrightEdges_2(long var0, long var2, int var4);

    private static native void BrightEdges_3(long var0, long var2);

    private static native void createQuaternionImage_0(long var0, long var2);

    private static native void qconj_0(long var0, long var2);

    private static native void qunitary_0(long var0, long var2);

    private static native void qmultiply_0(long var0, long var2, long var4);

    private static native void qdft_0(long var0, long var2, int var4, boolean var5);

    private static native void colorMatchTemplate_0(long var0, long var2, long var4);

    private static native void GradientDericheY_0(long var0, long var2, double var4, double var6);

    private static native void GradientDericheX_0(long var0, long var2, double var4, double var6);

    private static native long createDisparityWLSFilter_0(long var0);

    private static native long createRightMatcher_0(long var0);

    private static native long createDisparityWLSFilterGeneric_0(boolean var0);

    private static native int readGT_0(String var0, long var1);

    private static native double computeMSE_0(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native double computeBadPixelPercent_0(long var0, long var2, int var4, int var5, int var6, int var7, int var8);

    private static native double computeBadPixelPercent_1(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native void getDisparityVis_0(long var0, long var2, double var4);

    private static native void getDisparityVis_1(long var0, long var2);

    private static native long createEdgeBoxes_0(float var0, float var1, float var2, float var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    private static native long createEdgeBoxes_1(float var0, float var1, float var2, float var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private static native long createEdgeBoxes_2(float var0, float var1, float var2, float var3, int var4, float var5, float var6, float var7, float var8, float var9);

    private static native long createEdgeBoxes_3(float var0, float var1, float var2, float var3, int var4, float var5, float var6, float var7, float var8);

    private static native long createEdgeBoxes_4(float var0, float var1, float var2, float var3, int var4, float var5, float var6, float var7);

    private static native long createEdgeBoxes_5(float var0, float var1, float var2, float var3, int var4, float var5, float var6);

    private static native long createEdgeBoxes_6(float var0, float var1, float var2, float var3, int var4, float var5);

    private static native long createEdgeBoxes_7(float var0, float var1, float var2, float var3, int var4);

    private static native long createEdgeBoxes_8(float var0, float var1, float var2, float var3);

    private static native long createEdgeBoxes_9(float var0, float var1, float var2);

    private static native long createEdgeBoxes_10(float var0, float var1);

    private static native long createEdgeBoxes_11(float var0);

    private static native long createEdgeBoxes_12();

    private static native void edgePreservingFilter_0(long var0, long var2, int var4, double var5);

    private static native long createEdgeDrawing_0();

    private static native long createDTFilter_0(long var0, double var2, double var4, int var6, int var7);

    private static native long createDTFilter_1(long var0, double var2, double var4, int var6);

    private static native long createDTFilter_2(long var0, double var2, double var4);

    private static native void dtFilter_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11);

    private static native void dtFilter_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void dtFilter_2(long var0, long var2, long var4, double var6, double var8);

    private static native long createGuidedFilter_0(long var0, int var2, double var3, double var5);

    private static native long createGuidedFilter_1(long var0, int var2, double var3);

    private static native void guidedFilter_0(long var0, long var2, long var4, int var6, double var7, int var9, double var10);

    private static native void guidedFilter_1(long var0, long var2, long var4, int var6, double var7, int var9);

    private static native void guidedFilter_2(long var0, long var2, long var4, int var6, double var7);

    private static native long createAMFilter_0(double var0, double var2, boolean var4);

    private static native long createAMFilter_1(double var0, double var2);

    private static native void amFilter_0(long var0, long var2, long var4, double var6, double var8, boolean var10);

    private static native void amFilter_1(long var0, long var2, long var4, double var6, double var8);

    private static native void jointBilateralFilter_0(long var0, long var2, long var4, int var6, double var7, double var9, int var11);

    private static native void jointBilateralFilter_1(long var0, long var2, long var4, int var6, double var7, double var9);

    private static native void bilateralTextureFilter_0(long var0, long var2, int var4, int var5, double var6, double var8);

    private static native void bilateralTextureFilter_1(long var0, long var2, int var4, int var5, double var6);

    private static native void bilateralTextureFilter_2(long var0, long var2, int var4, int var5);

    private static native void bilateralTextureFilter_3(long var0, long var2, int var4);

    private static native void bilateralTextureFilter_4(long var0, long var2);

    private static native void rollingGuidanceFilter_0(long var0, long var2, int var4, double var5, double var7, int var9, int var10);

    private static native void rollingGuidanceFilter_1(long var0, long var2, int var4, double var5, double var7, int var9);

    private static native void rollingGuidanceFilter_2(long var0, long var2, int var4, double var5, double var7);

    private static native void rollingGuidanceFilter_3(long var0, long var2, int var4, double var5);

    private static native void rollingGuidanceFilter_4(long var0, long var2, int var4);

    private static native void rollingGuidanceFilter_5(long var0, long var2);

    private static native long createFastBilateralSolverFilter_0(long var0, double var2, double var4, double var6, double var8, int var10, double var11);

    private static native long createFastBilateralSolverFilter_1(long var0, double var2, double var4, double var6, double var8, int var10);

    private static native long createFastBilateralSolverFilter_2(long var0, double var2, double var4, double var6, double var8);

    private static native long createFastBilateralSolverFilter_3(long var0, double var2, double var4, double var6);

    private static native void fastBilateralSolverFilter_0(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, int var16, double var17);

    private static native void fastBilateralSolverFilter_1(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, int var16);

    private static native void fastBilateralSolverFilter_2(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14);

    private static native void fastBilateralSolverFilter_3(long var0, long var2, long var4, long var6, double var8, double var10, double var12);

    private static native void fastBilateralSolverFilter_4(long var0, long var2, long var4, long var6, double var8, double var10);

    private static native void fastBilateralSolverFilter_5(long var0, long var2, long var4, long var6, double var8);

    private static native void fastBilateralSolverFilter_6(long var0, long var2, long var4, long var6);

    private static native long createFastGlobalSmootherFilter_0(long var0, double var2, double var4, double var6, int var8);

    private static native long createFastGlobalSmootherFilter_1(long var0, double var2, double var4, double var6);

    private static native long createFastGlobalSmootherFilter_2(long var0, double var2, double var4);

    private static native void fastGlobalSmootherFilter_0(long var0, long var2, long var4, double var6, double var8, double var10, int var12);

    private static native void fastGlobalSmootherFilter_1(long var0, long var2, long var4, double var6, double var8, double var10);

    private static native void fastGlobalSmootherFilter_2(long var0, long var2, long var4, double var6, double var8);

    private static native void l0Smooth_0(long var0, long var2, double var4, double var6);

    private static native void l0Smooth_1(long var0, long var2, double var4);

    private static native void l0Smooth_2(long var0, long var2);

    private static native void covarianceEstimation_0(long var0, long var2, int var4, int var5);

    private static native void FastHoughTransform_0(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native void FastHoughTransform_1(long var0, long var2, int var4, int var5, int var6);

    private static native void FastHoughTransform_2(long var0, long var2, int var4, int var5);

    private static native void FastHoughTransform_3(long var0, long var2, int var4);

    private static native long createFastLineDetector_0(int var0, float var1, double var2, double var4, int var6, boolean var7);

    private static native long createFastLineDetector_1(int var0, float var1, double var2, double var4, int var6);

    private static native long createFastLineDetector_2(int var0, float var1, double var2, double var4);

    private static native long createFastLineDetector_3(int var0, float var1, double var2);

    private static native long createFastLineDetector_4(int var0, float var1);

    private static native long createFastLineDetector_5(int var0);

    private static native long createFastLineDetector_6();

    private static native void findEllipses_0(long var0, long var2, float var4, float var5, float var6);

    private static native void findEllipses_1(long var0, long var2, float var4, float var5);

    private static native void findEllipses_2(long var0, long var2, float var4);

    private static native void findEllipses_3(long var0, long var2);

    private static native void fourierDescriptor_0(long var0, long var2, int var4, int var5);

    private static native void fourierDescriptor_1(long var0, long var2, int var4);

    private static native void fourierDescriptor_2(long var0, long var2);

    private static native void transformFD_0(long var0, long var2, long var4, boolean var6);

    private static native void transformFD_1(long var0, long var2, long var4);

    private static native void contourSampling_0(long var0, long var2, int var4);

    private static native long createContourFitting_0(int var0, int var1);

    private static native long createContourFitting_1(int var0);

    private static native long createContourFitting_2();

    private static native long createSuperpixelLSC_0(long var0, int var2, float var3);

    private static native long createSuperpixelLSC_1(long var0, int var2);

    private static native long createSuperpixelLSC_2(long var0);

    private static native void PeiLinNormalization_0(long var0, long var2);

    private static native void RadonTransform_0(long var0, long var2, double var4, double var6, double var8, boolean var10, boolean var11);

    private static native void RadonTransform_1(long var0, long var2, double var4, double var6, double var8, boolean var10);

    private static native void RadonTransform_2(long var0, long var2, double var4, double var6, double var8);

    private static native void RadonTransform_3(long var0, long var2, double var4, double var6);

    private static native void RadonTransform_4(long var0, long var2, double var4);

    private static native void RadonTransform_5(long var0, long var2);

    private static native long createScanSegment_0(int var0, int var1, int var2, int var3, boolean var4);

    private static native long createScanSegment_1(int var0, int var1, int var2, int var3);

    private static native long createScanSegment_2(int var0, int var1, int var2);

    private static native long createSuperpixelSEEDS_0(int var0, int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private static native long createSuperpixelSEEDS_1(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    private static native long createSuperpixelSEEDS_2(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native long createSuperpixelSEEDS_3(int var0, int var1, int var2, int var3, int var4);

    private static native long createGraphSegmentation_0(double var0, float var2, int var3);

    private static native long createGraphSegmentation_1(double var0, float var2);

    private static native long createGraphSegmentation_2(double var0);

    private static native long createGraphSegmentation_3();

    private static native long createSelectiveSearchSegmentationStrategyColor_0();

    private static native long createSelectiveSearchSegmentationStrategySize_0();

    private static native long createSelectiveSearchSegmentationStrategyTexture_0();

    private static native long createSelectiveSearchSegmentationStrategyFill_0();

    private static native long createSelectiveSearchSegmentationStrategyMultiple_0();

    private static native long createSelectiveSearchSegmentationStrategyMultiple_1(long var0);

    private static native long createSelectiveSearchSegmentationStrategyMultiple_2(long var0, long var2);

    private static native long createSelectiveSearchSegmentationStrategyMultiple_3(long var0, long var2, long var4);

    private static native long createSelectiveSearchSegmentationStrategyMultiple_4(long var0, long var2, long var4, long var6);

    private static native long createSelectiveSearchSegmentation_0();

    private static native long createSuperpixelSLIC_0(long var0, int var2, int var3, float var4);

    private static native long createSuperpixelSLIC_1(long var0, int var2, int var3);

    private static native long createSuperpixelSLIC_2(long var0, int var2);

    private static native long createSuperpixelSLIC_3(long var0);

    private static native long createEdgeAwareInterpolator_0();

    private static native long createRICInterpolator_0();

    private static native long createRFFeatureGetter_0();

    private static native long createStructuredEdgeDetection_0(String var0, long var1);

    private static native long createStructuredEdgeDetection_1(String var0);

    private static native void weightedMedianFilter_0(long var0, long var2, long var4, int var6, double var7, int var9, long var10);

    private static native void weightedMedianFilter_1(long var0, long var2, long var4, int var6, double var7, int var9);

    private static native void weightedMedianFilter_2(long var0, long var2, long var4, int var6, double var7);

    private static native void weightedMedianFilter_3(long var0, long var2, long var4, int var6);
}

