/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.structured_light;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.structured_light.SinusoidalPattern_Params;
import org.opencv.structured_light.StructuredLightPattern;
import org.opencv.utils.Converters;

public class SinusoidalPattern
extends StructuredLightPattern {
    protected SinusoidalPattern(long addr) {
        super(addr);
    }

    public static SinusoidalPattern __fromPtr__(long addr) {
        return new SinusoidalPattern(addr);
    }

    public static SinusoidalPattern create(SinusoidalPattern_Params parameters2) {
        return SinusoidalPattern.__fromPtr__(SinusoidalPattern.create_0(parameters2.getNativeObjAddr()));
    }

    public static SinusoidalPattern create() {
        return SinusoidalPattern.__fromPtr__(SinusoidalPattern.create_1());
    }

    public void computePhaseMap(List<Mat> patternImages, Mat wrappedPhaseMap, Mat shadowMask, Mat fundamental) {
        Mat patternImages_mat = Converters.vector_Mat_to_Mat(patternImages);
        SinusoidalPattern.computePhaseMap_0(this.nativeObj, patternImages_mat.nativeObj, wrappedPhaseMap.nativeObj, shadowMask.nativeObj, fundamental.nativeObj);
    }

    public void computePhaseMap(List<Mat> patternImages, Mat wrappedPhaseMap, Mat shadowMask) {
        Mat patternImages_mat = Converters.vector_Mat_to_Mat(patternImages);
        SinusoidalPattern.computePhaseMap_1(this.nativeObj, patternImages_mat.nativeObj, wrappedPhaseMap.nativeObj, shadowMask.nativeObj);
    }

    public void computePhaseMap(List<Mat> patternImages, Mat wrappedPhaseMap) {
        Mat patternImages_mat = Converters.vector_Mat_to_Mat(patternImages);
        SinusoidalPattern.computePhaseMap_2(this.nativeObj, patternImages_mat.nativeObj, wrappedPhaseMap.nativeObj);
    }

    public void unwrapPhaseMap(Mat wrappedPhaseMap, Mat unwrappedPhaseMap, Size camSize, Mat shadowMask) {
        SinusoidalPattern.unwrapPhaseMap_0(this.nativeObj, wrappedPhaseMap.nativeObj, unwrappedPhaseMap.nativeObj, camSize.width, camSize.height, shadowMask.nativeObj);
    }

    public void unwrapPhaseMap(Mat wrappedPhaseMap, Mat unwrappedPhaseMap, Size camSize) {
        SinusoidalPattern.unwrapPhaseMap_1(this.nativeObj, wrappedPhaseMap.nativeObj, unwrappedPhaseMap.nativeObj, camSize.width, camSize.height);
    }

    public void findProCamMatches(Mat projUnwrappedPhaseMap, Mat camUnwrappedPhaseMap, List<Mat> matches) {
        Mat matches_mat = new Mat();
        SinusoidalPattern.findProCamMatches_0(this.nativeObj, projUnwrappedPhaseMap.nativeObj, camUnwrappedPhaseMap.nativeObj, matches_mat.nativeObj);
        Converters.Mat_to_vector_Mat(matches_mat, matches);
        matches_mat.release();
    }

    public void computeDataModulationTerm(List<Mat> patternImages, Mat dataModulationTerm, Mat shadowMask) {
        Mat patternImages_mat = Converters.vector_Mat_to_Mat(patternImages);
        SinusoidalPattern.computeDataModulationTerm_0(this.nativeObj, patternImages_mat.nativeObj, dataModulationTerm.nativeObj, shadowMask.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        SinusoidalPattern.delete(this.nativeObj);
    }

    private static native long create_0(long var0);

    private static native long create_1();

    private static native void computePhaseMap_0(long var0, long var2, long var4, long var6, long var8);

    private static native void computePhaseMap_1(long var0, long var2, long var4, long var6);

    private static native void computePhaseMap_2(long var0, long var2, long var4);

    private static native void unwrapPhaseMap_0(long var0, long var2, long var4, double var6, double var8, long var10);

    private static native void unwrapPhaseMap_1(long var0, long var2, long var4, double var6, double var8);

    private static native void findProCamMatches_0(long var0, long var2, long var4, long var6);

    private static native void computeDataModulationTerm_0(long var0, long var2, long var4, long var6);

    private static native void delete(long var0);
}

