/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;

public class FaceRecognizerSF {
    protected final long nativeObj;
    public static final int FR_COSINE = 0;
    public static final int FR_NORM_L2 = 1;

    protected FaceRecognizerSF(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static FaceRecognizerSF __fromPtr__(long addr) {
        return new FaceRecognizerSF(addr);
    }

    public void alignCrop(Mat src_img, Mat face_box, Mat aligned_img) {
        FaceRecognizerSF.alignCrop_0(this.nativeObj, src_img.nativeObj, face_box.nativeObj, aligned_img.nativeObj);
    }

    public void feature(Mat aligned_img, Mat face_feature) {
        FaceRecognizerSF.feature_0(this.nativeObj, aligned_img.nativeObj, face_feature.nativeObj);
    }

    public double match(Mat face_feature1, Mat face_feature2, int dis_type) {
        return FaceRecognizerSF.match_0(this.nativeObj, face_feature1.nativeObj, face_feature2.nativeObj, dis_type);
    }

    public double match(Mat face_feature1, Mat face_feature2) {
        return FaceRecognizerSF.match_1(this.nativeObj, face_feature1.nativeObj, face_feature2.nativeObj);
    }

    public static FaceRecognizerSF create(String model, String config2, int backend_id, int target_id) {
        return FaceRecognizerSF.__fromPtr__(FaceRecognizerSF.create_0(model, config2, backend_id, target_id));
    }

    public static FaceRecognizerSF create(String model, String config2, int backend_id) {
        return FaceRecognizerSF.__fromPtr__(FaceRecognizerSF.create_1(model, config2, backend_id));
    }

    public static FaceRecognizerSF create(String model, String config2) {
        return FaceRecognizerSF.__fromPtr__(FaceRecognizerSF.create_2(model, config2));
    }

    public static FaceRecognizerSF create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, int backend_id, int target_id) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceRecognizerSF.__fromPtr__(FaceRecognizerSF.create_3(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, backend_id, target_id));
    }

    public static FaceRecognizerSF create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, int backend_id) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceRecognizerSF.__fromPtr__(FaceRecognizerSF.create_4(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, backend_id));
    }

    public static FaceRecognizerSF create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceRecognizerSF.__fromPtr__(FaceRecognizerSF.create_5(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj));
    }

    protected void finalize() throws Throwable {
        FaceRecognizerSF.delete(this.nativeObj);
    }

    private static native void alignCrop_0(long var0, long var2, long var4, long var6);

    private static native void feature_0(long var0, long var2, long var4);

    private static native double match_0(long var0, long var2, long var4, int var6);

    private static native double match_1(long var0, long var2, long var4);

    private static native long create_0(String var0, String var1, int var2, int var3);

    private static native long create_1(String var0, String var1, int var2);

    private static native long create_2(String var0, String var1);

    private static native long create_3(String var0, long var1, long var3, int var5, int var6);

    private static native long create_4(String var0, long var1, long var3, int var5);

    private static native long create_5(String var0, long var1, long var3);

    private static native void delete(long var0);
}

