/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.face;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.face.PredictCollector;
import org.opencv.utils.Converters;

public class FaceRecognizer
extends Algorithm {
    protected FaceRecognizer(long addr) {
        super(addr);
    }

    public static FaceRecognizer __fromPtr__(long addr) {
        return new FaceRecognizer(addr);
    }

    public void train(List<Mat> src, Mat labels) {
        Mat src_mat = Converters.vector_Mat_to_Mat(src);
        FaceRecognizer.train_0(this.nativeObj, src_mat.nativeObj, labels.nativeObj);
    }

    public void update(List<Mat> src, Mat labels) {
        Mat src_mat = Converters.vector_Mat_to_Mat(src);
        FaceRecognizer.update_0(this.nativeObj, src_mat.nativeObj, labels.nativeObj);
    }

    public int predict_label(Mat src) {
        return FaceRecognizer.predict_label_0(this.nativeObj, src.nativeObj);
    }

    public void predict(Mat src, int[] label, double[] confidence) {
        double[] label_out = new double[1];
        double[] confidence_out = new double[1];
        FaceRecognizer.predict_0(this.nativeObj, src.nativeObj, label_out, confidence_out);
        if (label != null) {
            label[0] = (int)label_out[0];
        }
        if (confidence != null) {
            confidence[0] = confidence_out[0];
        }
    }

    public void predict_collect(Mat src, PredictCollector collector2) {
        FaceRecognizer.predict_collect_0(this.nativeObj, src.nativeObj, collector2.getNativeObjAddr());
    }

    public void write(String filename) {
        FaceRecognizer.write_0(this.nativeObj, filename);
    }

    public void read(String filename) {
        FaceRecognizer.read_0(this.nativeObj, filename);
    }

    public void setLabelInfo(int label, String strInfo) {
        FaceRecognizer.setLabelInfo_0(this.nativeObj, label, strInfo);
    }

    public String getLabelInfo(int label) {
        return FaceRecognizer.getLabelInfo_0(this.nativeObj, label);
    }

    public MatOfInt getLabelsByString(String str) {
        return MatOfInt.fromNativeAddr(FaceRecognizer.getLabelsByString_0(this.nativeObj, str));
    }

    @Override
    protected void finalize() throws Throwable {
        FaceRecognizer.delete(this.nativeObj);
    }

    private static native void train_0(long var0, long var2, long var4);

    private static native void update_0(long var0, long var2, long var4);

    private static native int predict_label_0(long var0, long var2);

    private static native void predict_0(long var0, long var2, double[] var4, double[] var5);

    private static native void predict_collect_0(long var0, long var2, long var4);

    private static native void write_0(long var0, String var2);

    private static native void read_0(long var0, String var2);

    private static native void setLabelInfo_0(long var0, int var2, String var3);

    private static native String getLabelInfo_0(long var0, int var2);

    private static native long getLabelsByString_0(long var0, String var2);

    private static native void delete(long var0);
}

