/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn_superres;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.utils.Converters;

public class DnnSuperResImpl {
    protected final long nativeObj;

    protected DnnSuperResImpl(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static DnnSuperResImpl __fromPtr__(long addr) {
        return new DnnSuperResImpl(addr);
    }

    public static DnnSuperResImpl create() {
        return DnnSuperResImpl.__fromPtr__(DnnSuperResImpl.create_0());
    }

    public void readModel(String path) {
        DnnSuperResImpl.readModel_0(this.nativeObj, path);
    }

    public void setModel(String algo, int scale2) {
        DnnSuperResImpl.setModel_0(this.nativeObj, algo, scale2);
    }

    public void setPreferableBackend(int backendId) {
        DnnSuperResImpl.setPreferableBackend_0(this.nativeObj, backendId);
    }

    public void setPreferableTarget(int targetId) {
        DnnSuperResImpl.setPreferableTarget_0(this.nativeObj, targetId);
    }

    public void upsample(Mat img, Mat result2) {
        DnnSuperResImpl.upsample_0(this.nativeObj, img.nativeObj, result2.nativeObj);
    }

    public void upsampleMultioutput(Mat img, List<Mat> imgs_new, MatOfInt scale_factors, List<String> node_names) {
        Mat imgs_new_mat = Converters.vector_Mat_to_Mat(imgs_new);
        MatOfInt scale_factors_mat = scale_factors;
        DnnSuperResImpl.upsampleMultioutput_0(this.nativeObj, img.nativeObj, imgs_new_mat.nativeObj, scale_factors_mat.nativeObj, node_names);
    }

    public int getScale() {
        return DnnSuperResImpl.getScale_0(this.nativeObj);
    }

    public String getAlgorithm() {
        return DnnSuperResImpl.getAlgorithm_0(this.nativeObj);
    }

    protected void finalize() throws Throwable {
        DnnSuperResImpl.delete(this.nativeObj);
    }

    private static native long create_0();

    private static native void readModel_0(long var0, String var2);

    private static native void setModel_0(long var0, String var2, int var3);

    private static native void setPreferableBackend_0(long var0, int var2);

    private static native void setPreferableTarget_0(long var0, int var2);

    private static native void upsample_0(long var0, long var2, long var4);

    private static native void upsampleMultioutput_0(long var0, long var2, long var4, long var6, List<String> var8);

    private static native int getScale_0(long var0);

    private static native String getAlgorithm_0(long var0);

    private static native void delete(long var0);
}

