/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import java.text.DecimalFormat;
import org.opencv.core.Core;

public class FpsMeter {
    private static final String TAG = "FpsMeter";
    private static final int STEP = 20;
    private static final DecimalFormat FPS_FORMAT = new DecimalFormat("0.00");
    private int mFramesCounter;
    private double mFrequency;
    private long mprevFrameTime;
    private String mStrfps;
    Paint mPaint;
    boolean mIsInitialized = false;
    int mWidth = 0;
    int mHeight = 0;

    public void init() {
        this.mFramesCounter = 0;
        this.mFrequency = Core.getTickFrequency();
        this.mprevFrameTime = Core.getTickCount();
        this.mStrfps = "";
        this.mPaint = new Paint();
        this.mPaint.setColor(-16776961);
        this.mPaint.setTextSize(20.0f);
    }

    public void measure() {
        if (!this.mIsInitialized) {
            this.init();
            this.mIsInitialized = true;
        } else {
            ++this.mFramesCounter;
            if (this.mFramesCounter % 20 == 0) {
                long time = Core.getTickCount();
                double fps = 20.0 * this.mFrequency / (double)(time - this.mprevFrameTime);
                this.mprevFrameTime = time;
                this.mStrfps = this.mWidth != 0 && this.mHeight != 0 ? FPS_FORMAT.format(fps) + " FPS@" + Integer.valueOf(this.mWidth) + "x" + Integer.valueOf(this.mHeight) : FPS_FORMAT.format(fps) + " FPS";
                Log.i((String)TAG, (String)this.mStrfps);
            }
        }
    }

    public void setResolution(int width2, int height2) {
        Log.d((String)TAG, (String)("FpsMeter.setResolution " + Integer.valueOf(this.mWidth) + "x" + Integer.valueOf(this.mHeight)));
        this.mWidth = width2;
        this.mHeight = height2;
    }

    public void draw(Canvas canvas, float offsetx, float offsety) {
        Log.d((String)TAG, (String)this.mStrfps);
        canvas.drawText(this.mStrfps, offsetx, offsety, this.mPaint);
    }
}

