/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Rect2d;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Rect2d>"})
@Properties(inherit={opencv_core.class})
public class Rect2dVector
extends Pointer {
    public Rect2dVector(Pointer p) {
        super(p);
    }

    public Rect2dVector(Rect2d value) {
        this(1L);
        this.put(0L, value);
    }

    public Rect2dVector(Rect2d ... array) {
        this(array.length);
        this.put(array);
    }

    public Rect2dVector() {
        this.allocate();
    }

    public Rect2dVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Rect2dVector put(@ByRef Rect2dVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Rect2d front() {
        return this.get(0L);
    }

    public Rect2d back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Rect2d get(@Cast(value={"size_t"}) long var1);

    public native Rect2dVector put(@Cast(value={"size_t"}) long var1, Rect2d var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Rect2d var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Rect2d[] get() {
        Rect2d[] array = new Rect2d[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.get());
    }

    public Rect2d pop_back() {
        long size2 = this.size();
        Rect2d value = this.get(size2 - 1L);
        this.resize(size2 - 1L);
        return value;
    }

    public Rect2dVector push_back(Rect2d value) {
        long size2 = this.size();
        this.resize(size2 + 1L);
        return this.put(size2, value);
    }

    public Rect2dVector put(Rect2d value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public Rect2dVector put(Rect2d ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Rect2d get();
    }
}

