/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import android.graphics.Bitmap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameConverter;

public class AndroidFrameConverter
extends FrameConverter<Bitmap> {
    Bitmap bitmap;
    ByteBuffer buffer;
    byte[] row;

    public Frame convert(byte[] data2, int width2, int height2) {
        if (this.frame == null || this.frame.imageWidth != width2 || this.frame.imageHeight != height2 || this.frame.imageChannels != 3) {
            if (this.frame != null) {
                this.frame.close();
            }
            this.frame = new Frame(width2, height2, 8, 3);
        }
        ByteBuffer out = (ByteBuffer)this.frame.image[0];
        int stride = this.frame.imageStride;
        int offset2 = height2 * width2;
        for (int i = 0; i < height2; ++i) {
            for (int j = 0; j < width2; ++j) {
                int Y = data2[i * width2 + j] & 0xFF;
                int V = data2[offset2 + i / 2 * width2 + 2 * (j / 2)] & 0xFF;
                int U = data2[offset2 + i / 2 * width2 + 2 * (j / 2) + 1] & 0xFF;
                U -= 128;
                V -= 128;
                if ((Y -= 16) < 0) {
                    Y = 0;
                }
                int B = 1192 * Y + 2066 * U;
                int G = 1192 * Y - 833 * V - 400 * U;
                int R = 1192 * Y + 1634 * V;
                R = Math.min(262143, Math.max(0, R));
                G = Math.min(262143, Math.max(0, G));
                B = Math.min(262143, Math.max(0, B));
                R >>= 10;
                R &= 0xFF;
                G >>= 10;
                B >>= 10;
                out.put(i * stride + 3 * j, (byte)(B &= 0xFF));
                out.put(i * stride + 3 * j + 1, (byte)(G &= 0xFF));
                out.put(i * stride + 3 * j + 2, (byte)R);
            }
        }
        return this.frame;
    }

    @Override
    public Frame convert(Bitmap bitmap2) {
        if (bitmap2 == null) {
            return null;
        }
        int channels = 0;
        switch (bitmap2.getConfig()) {
            case ALPHA_8: {
                channels = 1;
                break;
            }
            case RGB_565: 
            case ARGB_4444: {
                channels = 2;
                break;
            }
            case ARGB_8888: {
                channels = 4;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.frame == null || this.frame.imageWidth != bitmap2.getWidth() || this.frame.imageStride != bitmap2.getRowBytes() || this.frame.imageHeight != bitmap2.getHeight() || this.frame.imageChannels != channels) {
            if (this.frame != null) {
                this.frame.close();
            }
            this.frame = new Frame(bitmap2.getWidth(), bitmap2.getHeight(), 8, channels, bitmap2.getRowBytes());
        }
        bitmap2.copyPixelsToBuffer(this.frame.image[0].position(0));
        return this.frame;
    }

    ByteBuffer gray2rgba(ByteBuffer in, int width2, int height2, int stride, int rowBytes) {
        if (this.buffer == null || this.buffer.capacity() < height2 * rowBytes) {
            this.buffer = ByteBuffer.allocate(height2 * rowBytes);
        }
        if (this.row == null || this.row.length != stride) {
            this.row = new byte[stride];
        }
        for (int y2 = 0; y2 < height2; ++y2) {
            in.position(y2 * stride);
            in.get(this.row);
            for (int x2 = 0; x2 < width2; ++x2) {
                byte B = this.row[x2];
                int rgba = (B & 0xFF) << 24 | (B & 0xFF) << 16 | (B & 0xFF) << 8 | 0xFF;
                this.buffer.putInt(y2 * rowBytes + 4 * x2, rgba);
            }
        }
        return this.buffer;
    }

    ByteBuffer bgr2rgba(ByteBuffer in, int width2, int height2, int stride, int rowBytes) {
        if (!in.order().equals(ByteOrder.LITTLE_ENDIAN)) {
            in = in.order(ByteOrder.LITTLE_ENDIAN);
        }
        if (this.buffer == null || this.buffer.capacity() < height2 * rowBytes) {
            this.buffer = ByteBuffer.allocate(height2 * rowBytes);
        }
        for (int y2 = 0; y2 < height2; ++y2) {
            for (int x2 = 0; x2 < width2; ++x2) {
                int rgb;
                if (x2 < width2 - 1 || y2 < height2 - 1) {
                    rgb = in.getInt(y2 * stride + 3 * x2);
                } else {
                    int b = in.get(y2 * stride + 3 * x2) & 0xFF;
                    int g = in.get(y2 * stride + 3 * x2 + 1) & 0xFF;
                    int r = in.get(y2 * stride + 3 * x2 + 2) & 0xFF;
                    rgb = r << 16 | g << 8 | b;
                }
                this.buffer.putInt(y2 * rowBytes + 4 * x2, rgb << 8 | 0xFF);
            }
        }
        return this.buffer;
    }

    @Override
    public Bitmap convert(Frame frame2) {
        if (frame2 == null || frame2.image == null) {
            return null;
        }
        Bitmap.Config config2 = null;
        switch (frame2.imageChannels) {
            case 2: {
                config2 = Bitmap.Config.RGB_565;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                config2 = Bitmap.Config.ARGB_8888;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.bitmap == null || this.bitmap.getWidth() != frame2.imageWidth || this.bitmap.getHeight() != frame2.imageHeight || this.bitmap.getConfig() != config2) {
            this.bitmap = Bitmap.createBitmap((int)frame2.imageWidth, (int)frame2.imageHeight, (Bitmap.Config)config2);
        }
        ByteBuffer in = (ByteBuffer)frame2.image[0];
        int width2 = frame2.imageWidth;
        int height2 = frame2.imageHeight;
        int stride = frame2.imageStride;
        int rowBytes = this.bitmap.getRowBytes();
        if (frame2.imageChannels == 1) {
            this.gray2rgba(in, width2, height2, stride, rowBytes);
            this.bitmap.copyPixelsFromBuffer(this.buffer.position(0));
        } else if (frame2.imageChannels == 3) {
            this.bgr2rgba(in, width2, height2, stride, rowBytes);
            this.bitmap.copyPixelsFromBuffer(this.buffer.position(0));
        } else {
            this.bitmap.copyPixelsFromBuffer(in.position(0));
        }
        return this.bitmap;
    }
}

