/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.BuildMojo;
import org.bytedeco.javacpp.tools.ClassFilter;
import org.bytedeco.javacpp.tools.ClassScanner;
import org.bytedeco.javacpp.tools.Generator;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.UserClassLoader;

@Mojo(name="cache", defaultPhase=LifecyclePhase.NONE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CacheMojo
extends AbstractMojo {
    @Parameter(property="javacpp.classOrPackageName")
    String classOrPackageName = null;
    @Parameter(property="javacpp.classOrPackageNames")
    String[] classOrPackageNames = null;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    PluginDescriptor plugin;

    String join(String separator, Iterable<String> strings) {
        String string = "";
        for (String s : strings) {
            string = string + (string.length() > 0 ? separator : "") + s;
        }
        return string;
    }

    public void execute() throws MojoExecutionException {
        final Log log2 = this.getLog();
        Logger logger = new Logger(){

            @Override
            public void debug(String s) {
                log2.debug((CharSequence)s);
            }

            @Override
            public void info(String s) {
                log2.info((CharSequence)s);
            }

            @Override
            public void warn(String s) {
                log2.warn((CharSequence)s);
            }

            @Override
            public void error(String s) {
                log2.error((CharSequence)s);
            }
        };
        ClassFilter classFilter = new ClassFilter(){
            byte[] s = Generator.signature(Properties.class).getBytes(StandardCharsets.UTF_8);

            @Override
            public boolean keep(String filename, byte[] data2) {
                boolean found = false;
                block0: for (int i = 0; i < data2.length; ++i) {
                    for (int j = 0; i + j < data2.length && j < this.s.length; ++j) {
                        if (data2[i + j] != this.s[j]) continue block0;
                    }
                    found = true;
                    break;
                }
                return found;
            }
        };
        try {
            Set artifacts = this.project.getArtifacts();
            ArrayList<Class> classes2 = new ArrayList<Class>();
            UserClassLoader classLoader = new UserClassLoader();
            ClassScanner classScanner = new ClassScanner(logger, classes2, classLoader, classFilter);
            classLoader.addPaths(this.plugin.getPluginArtifact().getFile().getAbsolutePath());
            for (Artifact a : artifacts) {
                classLoader.addPaths(a.getFile().getAbsolutePath());
            }
            this.classOrPackageNames = BuildMojo.merge(this.classOrPackageNames, this.classOrPackageName);
            if (this.classOrPackageNames == null || this.classOrPackageNames.length == 0) {
                classScanner.addPackage(null, true);
            } else {
                for (String s : this.classOrPackageNames) {
                    classScanner.addClassOrPackage(s);
                }
            }
            LinkedHashSet<String> packages2 = new LinkedHashSet<String>();
            for (Class c : classes2) {
                try {
                    Method cachePackage = c.getMethod("cachePackage", new Class[0]);
                    logger.info("Caching " + c);
                    File f = (File)cachePackage.invoke((Object)c, new Object[0]);
                    if (f == null) continue;
                    packages2.add(Loader.getCanonicalPath(f));
                }
                catch (NoSuchMethodException cachePackage) {}
            }
            Class<?> loader = Class.forName("org.bytedeco.javacpp.Loader", true, classLoader);
            Method load2 = loader.getMethod("load", Class[].class);
            String[] filenames = (String[])load2.invoke(loader, new Object[]{classes2.toArray(new Class[classes2.size()])});
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            for (String filename : filenames) {
                if (filename == null) continue;
                paths.add(new File(filename).getParent());
            }
            System.out.println("PATH=" + this.join(File.pathSeparator, paths));
            System.out.println("PACKAGEPATH=" + this.join(File.pathSeparator, packages2));
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
            log2.error((CharSequence)("Failed to execute JavaCPP Loader: " + e.getMessage()));
            throw new MojoExecutionException("Failed to execute JavaCPP Loader", e);
        }
    }
}

