/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.uritemplate.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.uritemplate.Variables;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariablesImpl
implements Variables {
    private final Map<String, Object> variables = new LinkedHashMap<String, Object>();

    private static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    @Override
    public Variables set(String name, String value) {
        this.variables.put(name, value);
        return this;
    }

    @Override
    public Variables set(String name, List<String> value) {
        this.variables.put(name, value);
        return this;
    }

    @Override
    public Variables set(String name, Map<String, String> value) {
        this.variables.put(name, value);
        return this;
    }

    @Override
    public Variables addAll(JsonObject jsonObject) {
        for (Map.Entry<String, Object> entry : jsonObject) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JsonObject) {
                JsonObject json2 = (JsonObject)value;
                LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>(json2.size());
                for (Map.Entry entry2 : json2) {
                    map2.put((String)entry2.getKey(), VariablesImpl.toString(entry2.getValue()));
                }
                this.set(name, map2);
                continue;
            }
            if (value instanceof JsonArray) {
                JsonArray json2 = (JsonArray)value;
                ArrayList<String> list2 = new ArrayList<String>(json2.size());
                for (Object object : json2) {
                    list2.add(VariablesImpl.toString(object));
                }
                this.set(name, list2);
                continue;
            }
            this.set(name, VariablesImpl.toString(value));
        }
        return this;
    }

    @Override
    public Variables clear() {
        this.variables.clear();
        return this;
    }

    @Override
    public Object get(String name) {
        return this.variables.get(name);
    }

    @Override
    public Set<String> names() {
        return this.variables.keySet();
    }

    @Override
    public String getSingle(String name) {
        return (String)this.variables.get(name);
    }

    @Override
    public List<String> getList(String name) {
        return (List)this.variables.get(name);
    }

    @Override
    public Map<String, String> getMap(String name) {
        return (Map)this.variables.get(name);
    }
}

