/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.web.ParsedHeaderValue;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class HeaderParser {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderParser.class);
    private static final Comparator<ParsedHeaderValue> HEADER_SORTER = (left, right) -> right.weightedOrder() - left.weightedOrder();

    public static <T extends ParsedHeaderValue> List<T> convertToParsedHeaderValues(String unparsedHeaderValue, Function<String, T> objectCreator) {
        return HeaderParser.split(unparsedHeaderValue, ',', objectCreator);
    }

    public static <T extends ParsedHeaderValue> List<T> sort(List<T> headers) {
        headers.sort(HEADER_SORTER);
        return headers;
    }

    public static void parseHeaderValue(String headerContent, Consumer<String> valueCallback, Consumer<Float> weightCallback, BiConsumer<String, String> parameterCallback) {
        int paramIndex = headerContent.indexOf(59);
        if (paramIndex < 0) {
            valueCallback.accept(headerContent);
        } else {
            valueCallback.accept(headerContent.substring(0, paramIndex));
            if (paramIndex < headerContent.length()) {
                HeaderParser.split(headerContent.substring(paramIndex + 1), ';', part -> {
                    int idx = part.indexOf(61);
                    if (idx != -1) {
                        String key = part.substring(0, idx);
                        String val = part.substring(idx + 1);
                        if ("q".equalsIgnoreCase(key)) {
                            try {
                                weightCallback.accept(Float.valueOf(Float.parseFloat(val)));
                            }
                            catch (NumberFormatException e) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Found a \"q\" parameter with value \"" + val + "\" that was unparsable");
                                }
                            }
                        } else {
                            parameterCallback.accept(key, HeaderParser.unquote(val));
                        }
                    } else {
                        parameterCallback.accept((String)part, (String)null);
                    }
                    return null;
                });
            }
        }
    }

    public static void parseMIME(String headerContent, Consumer<String> componentCallback, Consumer<String> subcomponentCallback) {
        int slashIndex = headerContent.indexOf(47);
        int paramIndex = headerContent.indexOf(59, slashIndex + 1);
        if (slashIndex < 0) {
            componentCallback.accept("*");
        } else {
            componentCallback.accept(headerContent.substring(0, slashIndex).toLowerCase());
        }
        if (paramIndex < 0) {
            subcomponentCallback.accept(headerContent.substring(slashIndex + 1));
        } else {
            subcomponentCallback.accept(headerContent.substring(slashIndex + 1, paramIndex).toLowerCase());
        }
    }

    public static List<String> parseLanguageValue(String value) {
        if (value == null || value.length() == 0) {
            return Collections.emptyList();
        }
        LinkedList<String> parts = new LinkedList<String>();
        int start2 = 0;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (start2 == i && ch == ' ') {
                ++start2;
                continue;
            }
            if (ch != '-' && ch != '_') continue;
            int end2 = i;
            for (int j = i - 1; j >= start2 && value.charAt(j) == ' '; --j) {
                --end2;
            }
            if (end2 - start2 > 0) {
                parts.add(value.substring(start2, end2));
                if (parts.size() == 3) {
                    return parts;
                }
            }
            start2 = i + 1;
        }
        if (start2 < value.length()) {
            int end3 = value.length();
            for (int j = value.length() - 1; j >= start2 && value.charAt(j) == ' '; --j) {
                --end3;
            }
            if (end3 - start2 > 0) {
                parts.add(value.substring(start2, end3));
            }
        }
        return parts;
    }

    private static <T> List<T> split(String header, char split, Function<String, T> factory2) {
        if (header == null || header.length() == 0) {
            return Collections.emptyList();
        }
        LinkedList<T> parts = new LinkedList<T>();
        boolean quote = false;
        int start2 = 0;
        char last2 = '\u0000';
        for (int i = 0; i < header.length(); ++i) {
            char ch = header.charAt(i);
            if (start2 == i && ch == ' ') {
                ++start2;
                continue;
            }
            if (ch == '\"' && last2 != '\\') {
                quote = !quote;
            }
            last2 = ch;
            if (quote || ch != split) continue;
            int end2 = i;
            for (int j = i - 1; j >= start2 && header.charAt(j) == ' '; --j) {
                --end2;
            }
            if (end2 - start2 > 0) {
                parts.add(factory2.apply(header.substring(start2, end2)));
            }
            start2 = i + 1;
        }
        if (start2 < header.length()) {
            int end3 = header.length();
            for (int j = header.length() - 1; j >= start2 && header.charAt(j) == ' '; --j) {
                --end3;
            }
            if (end3 - start2 > 0) {
                parts.add(factory2.apply(header.substring(start2, end3)));
            }
        }
        return parts;
    }

    private static String unquote(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuilder sb = null;
        int start2 = 0;
        int end2 = value.length();
        if (value.charAt(start2) == '\"') {
            ++start2;
        }
        if (value.charAt(end2 - 1) == '\"') {
            --end2;
        }
        for (int i = start2; i < end2; ++i) {
            if (value.charAt(i) == '\\') {
                if (sb != null) continue;
                sb = new StringBuilder(value.substring(start2, i));
                continue;
            }
            if (sb == null) continue;
            sb.append(value.charAt(i));
        }
        if (sb != null) {
            return sb.toString();
        }
        if (end2 - start2 != value.length()) {
            return value.substring(start2, end2);
        }
        return value;
    }
}

