/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RoutingContextDecorator;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.Objects;

public class BlockingHandlerDecorator
implements Handler<RoutingContext> {
    private final boolean ordered;
    private final Handler<RoutingContext> decoratedHandler;

    public BlockingHandlerDecorator(Handler<RoutingContext> decoratedHandler, boolean ordered) {
        Objects.requireNonNull(decoratedHandler);
        this.decoratedHandler = decoratedHandler;
        this.ordered = ordered;
    }

    @Override
    public void handle(RoutingContext context2) {
        Route currentRoute = context2.currentRoute();
        context2.vertx().executeBlocking(() -> {
            this.decoratedHandler.handle(new RoutingContextDecorator(currentRoute, (RoutingContextInternal)context2));
            return null;
        }, this.ordered).onComplete(res -> {
            if (res.failed()) {
                context2.fail(res.cause());
            }
        });
    }
}

