/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.healthchecks.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.healthchecks.CheckResult;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.healthchecks.HealthCheckHandler;
import io.vertx.ext.web.healthchecks.impl.JsonCredentials;
import io.vertx.ext.web.impl.Utils;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class HealthCheckHandlerImpl
implements HealthCheckHandler {
    private final Logger log = LoggerFactory.getLogger(HealthCheckHandler.class);
    private final HealthChecks healthChecks;
    private final AuthenticationProvider authProvider;
    private volatile Function<CheckResult, Future<CheckResult>> resultMapper;

    public HealthCheckHandlerImpl(Vertx vertx, AuthenticationProvider provider) {
        this.healthChecks = HealthChecks.create((Vertx)vertx);
        this.authProvider = provider;
    }

    public HealthCheckHandlerImpl(HealthChecks hc, AuthenticationProvider provider) {
        this.healthChecks = Objects.requireNonNull(hc);
        this.authProvider = provider;
    }

    @Override
    public HealthCheckHandler register(String name, Handler<Promise<Status>> procedure) {
        this.healthChecks.register(name, procedure);
        return this;
    }

    @Override
    public HealthCheckHandler register(String name, long timeout2, Handler<Promise<Status>> procedure) {
        this.healthChecks.register(name, timeout2, procedure);
        return this;
    }

    @Override
    public HealthCheckHandler resultMapper(Function<CheckResult, Future<CheckResult>> resultMapper) {
        this.resultMapper = resultMapper;
        return this;
    }

    @Override
    public void handle(RoutingContext rc) {
        String path = Utils.pathOffset(rc.normalizedPath(), rc);
        String id = path.length() > 0 ? path.substring(1) : path;
        if (this.authProvider != null) {
            JsonObject authData = new JsonObject();
            rc.request().headers().forEach(entry -> authData.put((String)entry.getKey(), entry.getValue()));
            rc.request().params().forEach(entry -> authData.put((String)entry.getKey(), entry.getValue()));
            if (rc.request().method() == HttpMethod.POST && rc.request().getHeader(HttpHeaders.CONTENT_TYPE) != null && rc.request().getHeader(HttpHeaders.CONTENT_TYPE).contains("application/json")) {
                try {
                    JsonObject body = rc.body().asJsonObject();
                    if (body != null) {
                        authData.mergeIn(body);
                    }
                }
                catch (Exception err2) {
                    this.log.error("Invalid authentication json body", err2);
                }
            }
            this.authProvider.authenticate(new JsonCredentials(authData)).onFailure(err -> rc.response().setStatusCode(403).end()).onSuccess(user -> this.healthChecks.checkStatus(id).onComplete(this.healthReportHandler(rc)));
        } else {
            this.healthChecks.checkStatus(id).onComplete(this.healthReportHandler(rc));
        }
    }

    private Completable<CheckResult> healthReportHandler(RoutingContext rc) {
        Completable<CheckResult> handler = (json2, err) -> {
            HttpServerResponse response2 = rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json;charset=UTF-8");
            if (err != null) {
                if (err.getMessage().toLowerCase().contains("not found")) {
                    response2.setStatusCode(404);
                } else {
                    response2.setStatusCode(400);
                }
                response2.end("{\"message\": \"" + err.getMessage() + "\"}");
            } else {
                this.buildResponse((CheckResult)json2, response2);
            }
        };
        if (this.resultMapper != null) {
            Promise<CheckResult> promise = Promise.promise();
            promise.future().flatMap(this.resultMapper).onComplete(handler);
            return promise;
        }
        return handler;
    }

    private void buildResponse(CheckResult json2, HttpServerResponse response2) {
        int status;
        int n = status = CheckResult.isUp((CheckResult)json2) ? 200 : 503;
        if (status == 503 && this.hasProcedureError(json2)) {
            status = 500;
        }
        List checks2 = json2.getChecks();
        if (status == 200 && checks2 != null && checks2.isEmpty()) {
            response2.setStatusCode(204).end();
            return;
        }
        response2.setStatusCode(status).end(json2.toJson().encode());
    }

    @Override
    public synchronized HealthCheckHandler unregister(String name) {
        this.healthChecks.unregister(name);
        return this;
    }

    private boolean hasProcedureError(CheckResult json2) {
        JsonObject data2 = json2.getData();
        if (data2 != null && data2.getBoolean("procedure-execution-failure", false).booleanValue()) {
            return true;
        }
        List checks2 = json2.getChecks();
        if (checks2 != null) {
            for (CheckResult check2 : checks2) {
                if (!this.hasProcedureError(check2)) continue;
                return true;
            }
        }
        return false;
    }
}

