/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.JsonCodec;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;
import io.vertx.ext.web.handler.sockjs.impl.TransportListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

class SockJSSession
extends SockJSSocketBase
implements Shareable {
    private static final Logger LOG = LoggerFactory.getLogger(SockJSSession.class);
    private final LocalMap<String, SockJSSession> sessions;
    private final Deque<String> pendingWrites = new LinkedList<String>();
    private final ContextInternal context;
    private final String id;
    private final long timeout;
    private final Handler<SockJSSocket> sockHandler;
    private final long heartbeatID;
    private final List<Completable<Void>> writeAcks = new ArrayList<Completable<Void>>();
    private TransportListener listener;
    private boolean closed;
    private boolean openWritten;
    private long timeoutTimerID = -1L;
    private int maxQueueSize = 65536;
    private int messagesSize;
    private InboundMessageQueue<Buffer> pendingReads;
    private Handler<Buffer> handler;
    private Handler<Void> drainHandler;
    private Handler<Void> endHandler;
    private Handler<Void> closeHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean handleCalled;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private String uri;
    private MultiMap headers;
    private Context transportCtx;

    SockJSSession(Vertx vertx, LocalMap<String, SockJSSession> sessions, RoutingContext rc, SockJSHandlerOptions options2, Handler<SockJSSocket> sockHandler) {
        this(vertx, sessions, rc, null, options2, sockHandler);
    }

    SockJSSession(Vertx vertx, LocalMap<String, SockJSSession> sessions, RoutingContext rc, String id, SockJSHandlerOptions options2, Handler<SockJSSocket> sockHandler) {
        super(vertx, rc, options2);
        this.sessions = sessions;
        this.id = id;
        this.timeout = id == null ? -1L : options2.getSessionTimeout();
        this.sockHandler = sockHandler;
        this.context = (ContextInternal)vertx.getOrCreateContext();
        this.initPendingReads();
        this.heartbeatID = vertx.setPeriodic(options2.getHeartbeatInterval(), tid -> {
            if (this.listener != null) {
                this.listener.sendFrame("h");
            }
        });
    }

    private void initPendingReads() {
        this.pendingReads = new InboundMessageQueue<Buffer>(this.context.executor(), this.context.executor()){

            @Override
            protected void handleMessage(Buffer msg) {
                Handler<Buffer> h = SockJSSession.this.handler;
                if (h != null) {
                    SockJSSession.this.context.dispatch(msg, h);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInternal(String msg, Promise<Void> promise) {
        SockJSSession sockJSSession = this;
        synchronized (sockJSSession) {
            this.pendingWrites.add(msg);
            this.messagesSize += msg.length();
            this.writeAcks.add(promise);
        }
        if (this.listener != null) {
            Context ctx = this.transportCtx;
            if (Vertx.currentContext() != ctx) {
                ctx.runOnContext(v -> this.writePendingMessages());
            } else {
                this.writePendingMessages();
            }
        }
    }

    @Override
    public Future<Void> write(Buffer buffer) {
        ContextInternal callerCtx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = callerCtx.promise();
        if (this.isClosed()) {
            Context ctx = this.transportCtx;
            if (Vertx.currentContext() != ctx) {
                this.vertx.runOnContext(v -> promise.fail(NetSocketInternal.CLOSED_EXCEPTION));
            } else {
                promise.fail(NetSocketInternal.CLOSED_EXCEPTION);
            }
        } else {
            String msg = buffer.toString();
            this.writeInternal(msg, promise);
        }
        return promise.future();
    }

    @Override
    public Future<Void> write(String text2) {
        ContextInternal callerCtx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = callerCtx.promise();
        if (this.isClosed()) {
            Context ctx = this.transportCtx;
            if (Vertx.currentContext() != ctx) {
                this.vertx.runOnContext(v -> promise.fail(NetSocketInternal.CLOSED_EXCEPTION));
            } else {
                promise.fail(NetSocketInternal.CLOSED_EXCEPTION);
            }
        } else {
            this.writeInternal(text2, promise);
        }
        return promise.future();
    }

    @Override
    public SockJSSession handler(Handler<Buffer> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public SockJSSession fetch(long amount) {
        this.pendingReads.fetch(amount);
        return this;
    }

    @Override
    public SockJSSession pause() {
        this.pendingReads.pause();
        return this;
    }

    @Override
    public SockJSSession resume() {
        this.pendingReads.fetch(Long.MAX_VALUE);
        return this;
    }

    @Override
    public SockJSSession setWriteQueueMaxSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("maxQueueSize must be >= 1");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.messagesSize >= this.maxQueueSize;
    }

    @Override
    public SockJSSession drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    @Override
    public SockJSSession exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public SockJSSession endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public SockJSSocket closeHandler(Handler<Void> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SockJSSession sockJSSession = this;
        synchronized (sockJSSession) {
            if (!this.closed) {
                this.closed = true;
                this.handleClosed();
            }
        }
        this.doClose();
    }

    private void doClose() {
        Context ctx = this.transportCtx;
        if (ctx != Vertx.currentContext()) {
            ctx.runOnContext(v -> this.doClose());
        } else if (this.listener != null && this.handleCalled) {
            this.listener.sessionClosed();
        }
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    boolean isClosed() {
        return this.closed;
    }

    synchronized void resetListener() {
        this.listener = null;
        this.setTimer();
    }

    private void cancelTimer() {
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
    }

    private void setTimer() {
        if (this.timeout != -1L) {
            this.cancelTimer();
            this.timeoutTimerID = this.vertx.setTimer(this.timeout, id1 -> {
                this.vertx.cancelTimer(this.heartbeatID);
                TransportListener listener = this.listener;
                if (listener == null) {
                    this.shutdown();
                }
                if (listener != null) {
                    listener.close();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePendingMessages() {
        TransportListener listener = this.listener;
        if (listener != null) {
            List acks;
            String json2;
            SockJSSession sockJSSession = this;
            synchronized (sockJSSession) {
                if (!this.pendingWrites.isEmpty()) {
                    json2 = JsonCodec.encode(this.pendingWrites.toArray(new String[0]));
                    this.pendingWrites.clear();
                    if (!this.writeAcks.isEmpty()) {
                        acks = new ArrayList<Completable<Void>>(this.writeAcks);
                        this.writeAcks.clear();
                    } else {
                        acks = Collections.emptyList();
                    }
                    this.messagesSize = 0;
                } else {
                    json2 = null;
                    acks = Collections.emptyList();
                }
            }
            if (json2 != null) {
                if (!acks.isEmpty()) {
                    listener.sendFrame("a" + json2).onComplete((res, err) -> acks.forEach(a -> a.complete(res, err)));
                } else {
                    listener.sendFrame("a" + json2);
                }
            }
            if (this.drainHandler != null) {
                Handler<Void> dh = this.drainHandler;
                this.drainHandler = null;
                this.context.runOnContext(dh);
            }
        }
    }

    Context context() {
        return this.transportCtx;
    }

    void register(HttpServerRequest req, TransportListener lst) {
        this.transportCtx = this.vertx.getOrCreateContext();
        this.localAddress = req.localAddress();
        this.remoteAddress = req.remoteAddress();
        this.uri = req.uri();
        this.headers = BaseTransport.removeCookieHeaders(req.headers());
        if (this.closed) {
            this.writeClosed(lst);
            lst.close();
        } else if (this.listener != null) {
            this.writeClosed(lst, 2010, "Another connection still open");
            lst.close();
        } else {
            this.cancelTimer();
            this.listener = lst;
            if (!this.openWritten) {
                this.writeOpen(lst);
                this.sockHandler.handle(this);
                this.handleCalled = true;
            }
            if (this.listener != null) {
                if (this.closed) {
                    this.writeClosed(lst);
                    this.listener = null;
                    lst.close();
                } else if (!this.pendingWrites.isEmpty()) {
                    this.writePendingMessages();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        super.close();
        if (this.heartbeatID != -1L) {
            this.vertx.cancelTimer(this.heartbeatID);
        }
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
        if (this.id != null) {
            this.sessions.remove(this.id);
        }
        SockJSSession sockJSSession = this;
        synchronized (sockJSSession) {
            if (!this.closed) {
                this.closed = true;
                this.handleClosed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClosed() {
        SockJSSession sockJSSession = this;
        synchronized (sockJSSession) {
            this.initPendingReads();
            this.pendingWrites.clear();
            this.writeAcks.forEach(handler -> this.context.runOnContext(v -> handler.complete(null, NetSocketInternal.CLOSED_EXCEPTION)));
            this.writeAcks.clear();
        }
        Handler<Void> handler2 = this.endHandler;
        if (handler2 != null) {
            this.context.runOnContext(handler2);
        }
        if ((handler2 = this.closeHandler) != null) {
            this.context.runOnContext(handler2);
        }
    }

    boolean handleMessages(String messages) {
        List<String> msgList = JsonCodec.decodeValues(messages);
        if (msgList == null) {
            return false;
        }
        this.handleMessages(msgList);
        return true;
    }

    private void handleMessages(List<String> messages) {
        if (this.context == Vertx.currentContext()) {
            for (String msg : messages) {
                this.pendingReads.write(Buffer.buffer(msg));
            }
        } else {
            this.context.runOnContext(v -> this.handleMessages(messages));
        }
    }

    void handleException(Throwable t) {
        Handler<Throwable> eh = this.exceptionHandler;
        if (eh != null) {
            if (this.context == Vertx.currentContext()) {
                eh.handle(t);
            } else {
                this.context.runOnContext(v -> this.handleException(t));
            }
        } else {
            LOG.error("Unhandled exception", t);
        }
    }

    void writeClosed(TransportListener lst) {
        this.writeClosed(lst, 3000, "Go away!");
    }

    private void writeClosed(TransportListener lst, int code, String msg) {
        String sb = "c[" + code + ",\"" + msg + "\"]";
        lst.sendFrame(sb);
    }

    private void writeOpen(TransportListener lst) {
        lst.sendFrame("o");
        this.openWritten = true;
    }
}

