/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.impl.UserHolder;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.Signature;
import io.vertx.ext.web.impl.UserContextInternal;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SessionInternal;
import java.util.Objects;

public class SessionHandlerImpl
implements SessionHandler {
    public static final String SESSION_USER_HOLDER_KEY = "__vertx.userHolder";
    public static final String SESSION_FLUSHED_KEY = "__vertx.session-flushed";
    public static final String SESSION_STOREUSER_KEY = "__vertx.session-storeuser";
    private static final Logger LOG = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private final SessionStore sessionStore;
    private String sessionCookieName = "vertx-web.session";
    private String sessionCookiePath = "/";
    private long sessionTimeout = 1800000L;
    private boolean nagHttps = true;
    private boolean sessionCookieSecure = false;
    private boolean sessionCookieHttpOnly = false;
    private int minLength = 16;
    private boolean lazySession = false;
    private long cookieMaxAge = -1L;
    private boolean cookieless;
    private CookieSameSite cookieSameSite;
    private Signature signature;

    public SessionHandlerImpl(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    @Override
    public SessionHandler setSessionTimeout(long timeout2) {
        this.sessionTimeout = timeout2;
        return this;
    }

    @Override
    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.sessionCookieSecure = secure;
        return this;
    }

    @Override
    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.sessionCookieHttpOnly = httpOnly;
        return this;
    }

    @Override
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    @Override
    public SessionHandler setSessionCookiePath(String sessionCookiePath) {
        this.sessionCookiePath = sessionCookiePath;
        return this;
    }

    @Override
    public SessionHandler setMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    @Override
    public SessionHandler setCookieSameSite(CookieSameSite policy) {
        this.cookieSameSite = policy;
        return this;
    }

    @Override
    public SessionHandler setLazySession(boolean lazySession) {
        this.lazySession = lazySession;
        return this;
    }

    @Override
    public SessionHandler setCookieMaxAge(long cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
        return this;
    }

    @Override
    public SessionHandler setCookieless(boolean cookieless) {
        this.cookieless = cookieless;
        return this;
    }

    @Override
    public SessionHandler setSigningSecret(String secret) {
        this.signature = new Signature(secret);
        return this;
    }

    @Override
    public Future<Void> flush(RoutingContext context2, boolean ignoreStatus) {
        return this.flush(context2, false, ignoreStatus);
    }

    private void setCookieProperties(Cookie cookie, boolean expired) {
        cookie.setPath(this.sessionCookiePath);
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        cookie.setSameSite(this.cookieSameSite);
        if (!expired && this.cookieMaxAge >= 0L) {
            cookie.setMaxAge(this.cookieMaxAge);
        }
    }

    private Future<Void> flush(RoutingContext context2, boolean skipCrc, boolean ignoreStatus) {
        Cookie expiredCookie;
        boolean sessionUsed = context2.isSessionAccessed();
        Session session = context2.session();
        ContextInternal ctx = (ContextInternal)context2.vertx().getOrCreateContext();
        if (session == null) {
            return ctx.succeededFuture();
        }
        if (!session.isDestroyed()) {
            int currentStatusCode = context2.response().getStatusCode();
            if (ignoreStatus || currentStatusCode >= 200 && currentStatusCode < 400) {
                Boolean storeUser = (Boolean)context2.get(SESSION_STOREUSER_KEY);
                if (storeUser != null && storeUser.booleanValue() && context2.user() != null) {
                    session.put(SESSION_USER_HOLDER_KEY, new UserHolder(context2));
                }
                if (session.isRegenerated()) {
                    if (this.cookieless) {
                        session.setAccessed();
                    } else {
                        Cookie cookie = this.requestSessionCookie(context2);
                        session.setAccessed();
                        if (cookie != null) {
                            String cookieValue = session.value();
                            if (Objects.nonNull(this.signature)) {
                                cookieValue = this.signature.sign(cookieValue);
                            }
                            cookie.setValue(cookieValue);
                            this.setCookieProperties(cookie, false);
                        } else {
                            this.sessionCookie(context2, session.value());
                        }
                    }
                    return this.sessionStore.delete(session.oldId()).compose(delete -> this.sessionStore.put(session).onSuccess(put -> {
                        context2.put(SESSION_FLUSHED_KEY, true);
                        if (session instanceof SessionInternal) {
                            ((SessionInternal)((Object)session)).flushed(skipCrc);
                        }
                    }));
                }
                if (!this.lazySession || sessionUsed) {
                    if (!this.cookieless && this.requestSessionCookie(context2) == null) {
                        this.sessionCookie(context2, session.value());
                    }
                    session.setAccessed();
                    return this.sessionStore.put(session).onSuccess(put -> {
                        context2.put(SESSION_FLUSHED_KEY, true);
                        if (session instanceof SessionInternal) {
                            ((SessionInternal)((Object)session)).flushed(skipCrc);
                        }
                    });
                }
                context2.put(SESSION_FLUSHED_KEY, true);
                return ctx.succeededFuture();
            }
            context2.put(SESSION_FLUSHED_KEY, true);
            return ctx.succeededFuture();
        }
        if (!this.cookieless && (expiredCookie = context2.response().removeCookie(this.sessionCookieName)) != null) {
            this.setCookieProperties(expiredCookie, true);
        }
        if (session.isRegenerated()) {
            return this.sessionStore.delete(session.oldId()).compose(delete -> this.sessionStore.delete(session.id()).onSuccess(delete2 -> context2.put(SESSION_FLUSHED_KEY, true)));
        }
        return this.sessionStore.delete(session.id()).onSuccess(delete -> context2.put(SESSION_FLUSHED_KEY, true));
    }

    @Override
    public void handle(RoutingContext context2) {
        String sessionID;
        String uri;
        if (((RoutingContextInternal)context2).seenHandler(8)) {
            context2.next();
            return;
        }
        ((RoutingContextInternal)context2).visitHandler(8);
        HttpServerRequest request = context2.request();
        if (this.nagHttps && LOG.isDebugEnabled() && !(uri = request.absoluteURI()).startsWith("https:")) {
            LOG.debug("Using session cookies without https could make you susceptible to session hijacking: " + uri);
        }
        if ((sessionID = this.getSessionId(context2)) != null && sessionID.length() > this.minLength) {
            if (!context2.request().isEnded()) {
                context2.request().pause();
            }
            ContextInternal ctx = (ContextInternal)context2.vertx().getOrCreateContext();
            this.getSession(ctx, sessionID).onFailure(err -> {
                if (!context2.request().isEnded()) {
                    context2.request().resume();
                }
                context2.fail((Throwable)err);
            }).onSuccess(session -> {
                if (session != null) {
                    ((RoutingContextInternal)context2).setSession((Session)session);
                    UserHolder holder2 = (UserHolder)session.get(SESSION_USER_HOLDER_KEY);
                    if (holder2 != null) {
                        holder2.refresh(context2);
                    } else {
                        context2.put(SESSION_STOREUSER_KEY, true);
                    }
                    this.addStoreSessionHandler(context2);
                } else {
                    this.createNewSession(context2);
                }
                if (!context2.request().isEnded()) {
                    context2.request().resume();
                }
                context2.next();
            });
        } else {
            this.createNewSession(context2);
            context2.next();
        }
    }

    @Override
    public Session newSession(RoutingContext context2) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        ((RoutingContextInternal)context2).setSession(session);
        if (!this.cookieless) {
            context2.response().removeCookie(this.sessionCookieName, false);
        }
        context2.put(SESSION_STOREUSER_KEY, true);
        this.flush(context2, true, true).onFailure(err -> LOG.warn("Failed to flush the session to the underlying store", (Throwable)err));
        return session;
    }

    @Override
    public Future<Void> setUser(RoutingContext context2, User user) {
        if (!this.cookieless) {
            context2.response().removeCookie(this.sessionCookieName, false);
        }
        ((UserContextInternal)context2.userContext()).setUser(user);
        context2.put(SESSION_STOREUSER_KEY, true);
        return this.flush(context2, true, true);
    }

    private String getSessionId(RoutingContext context2) {
        if (this.cookieless) {
            String path = context2.normalizedPath();
            int s = -1;
            int e = -1;
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) == '(') {
                    s = i + 1;
                    continue;
                }
                if (path.charAt(i) != ')' || s == -1) continue;
                e = i;
                break;
            }
            if (s != -1 && e != -1 && s < e) {
                return path.substring(s, e);
            }
        } else {
            Cookie cookie = this.requestSessionCookie(context2);
            if (cookie != null) {
                if (Objects.nonNull(this.signature)) {
                    return this.signature.parse(cookie.getValue());
                }
                return cookie.getValue();
            }
        }
        return null;
    }

    private Future<Session> getSession(ContextInternal context2, String sessionID) {
        return this.doGetSession(context2, System.currentTimeMillis(), sessionID);
    }

    private Future<Session> doGetSession(ContextInternal context2, long startTime, String sessionID) {
        return this.sessionStore.get(sessionID).compose(session -> {
            if (session == null) {
                PromiseInternal<Session> retry2 = context2.promise();
                this.doGetSession(context2.owner(), startTime, sessionID, retry2);
                return retry2.future();
            }
            return context2.succeededFuture(session);
        });
    }

    private void doGetSession(Vertx vertx, long startTime, String sessionID, Completable<Session> resultHandler) {
        this.sessionStore.get(sessionID).onComplete(res -> {
            if (res.succeeded() && res.result() == null && System.currentTimeMillis() - startTime < this.sessionStore.retryTimeout()) {
                vertx.setTimer(5L, v -> this.doGetSession(vertx, startTime, sessionID, resultHandler));
                return;
            }
            resultHandler.complete((Session)res.result(), res.cause());
        });
    }

    private void addStoreSessionHandler(RoutingContext context2) {
        context2.addHeadersEndHandler(v -> {
            Boolean flushed = (Boolean)context2.get(SESSION_FLUSHED_KEY);
            if (flushed == null || !flushed.booleanValue()) {
                this.flush(context2, true, false).onFailure(err -> LOG.warn("Failed to flush the session to the underlying store", (Throwable)err));
            }
        });
    }

    private void createNewSession(RoutingContext context2) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        ((RoutingContextInternal)context2).setSession(session);
        if (!this.cookieless) {
            context2.response().removeCookie(this.sessionCookieName, false);
        }
        context2.put(SESSION_STOREUSER_KEY, true);
        this.addStoreSessionHandler(context2);
    }

    private Cookie requestSessionCookie(RoutingContext context2) {
        return context2.request().getCookie(this.sessionCookieName);
    }

    private void sessionCookie(RoutingContext context2, String cookieValue) {
        if (Objects.nonNull(this.signature)) {
            cookieValue = this.signature.sign(cookieValue);
        }
        Cookie cookie = Cookie.cookie(this.sessionCookieName, cookieValue);
        this.setCookieProperties(cookie, false);
        context2.response().addCookie(cookie);
    }
}

