/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerInternal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ChainAuthHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements ChainAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChainAuthHandler.class);
    private static final String HANDLER_KEY_PREFIX = "__vertx.auth.chain.idx.";
    private static final AtomicInteger HANDLER_KEY_SEQ = new AtomicInteger();
    private final List<AuthenticationHandlerInternal> handlers = new ArrayList<AuthenticationHandlerInternal>();
    private final boolean all;
    private final String chainAuthHandlerKey;
    private int willRedirect = -1;

    public ChainAuthHandlerImpl(boolean all) {
        super(null);
        this.all = all;
        this.chainAuthHandlerKey = HANDLER_KEY_PREFIX + HANDLER_KEY_SEQ.getAndIncrement();
    }

    @Override
    public boolean performsRedirect() {
        return this.willRedirect != -1;
    }

    @Override
    public synchronized ChainAuthHandler add(AuthenticationHandler other) {
        if (this.performsRedirect()) {
            throw new IllegalStateException("Cannot add a handler after a handler known to perform a HTTP redirect: " + String.valueOf(this.handlers.get(this.willRedirect)));
        }
        AuthenticationHandlerInternal otherInternal = (AuthenticationHandlerInternal)other;
        if (otherInternal.performsRedirect()) {
            this.willRedirect = this.handlers.size();
        }
        this.handlers.add(otherInternal);
        return this;
    }

    @Override
    public Future<User> authenticate(RoutingContext context2) {
        if (this.handlers.isEmpty()) {
            return Future.failedFuture("No providers in the auth chain.");
        }
        Promise<User> promise = Promise.promise();
        this.iterate(0, context2, null, null, promise);
        return promise.future();
    }

    private void iterate(int idx, RoutingContext ctx, User result2, Throwable exception, Completable<User> handler) {
        if (idx >= this.handlers.size()) {
            if (this.all) {
                handler.complete(result2, exception);
            } else {
                handler.complete(null, exception);
            }
            return;
        }
        AuthenticationHandlerInternal authHandler = this.handlers.get(idx);
        authHandler.authenticate(ctx).onFailure(err -> {
            if (!this.all && err instanceof HttpException) {
                HttpException ex = (HttpException)err;
                switch (ex.getStatusCode()) {
                    case 302: 
                    case 400: 
                    case 401: 
                    case 403: {
                        this.iterate(idx + 1, ctx, null, ex, handler);
                        return;
                    }
                }
            }
            handler.complete((User)null, (Throwable)err);
        }).onSuccess(user -> {
            if (this.all) {
                this.iterate(idx + 1, ctx, (User)user, null, handler);
            } else {
                ctx.put(this.chainAuthHandlerKey, idx);
                handler.complete((User)user, null);
            }
        });
    }

    @Override
    public boolean setAuthenticateHeader(RoutingContext ctx) {
        boolean added = false;
        for (AuthenticationHandlerInternal authHandler : this.handlers) {
            if (this.all && added) {
                LOG.warn("Multiple WWW-Authenticate headers will be suppressed on a ALL chain");
                break;
            }
            added |= authHandler.setAuthenticateHeader(ctx);
        }
        return added;
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        Integer idx;
        if (this.all || (idx = (Integer)ctx.get(this.chainAuthHandlerKey)) == null) {
            ctx.next();
        } else {
            this.handlers.get(idx).postAuthentication(ctx);
        }
    }
}

