/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;

public class BasicAuthHandlerImpl
extends HTTPAuthorizationHandler<AuthenticationProvider>
implements BasicAuthHandler {
    public BasicAuthHandlerImpl(AuthenticationProvider authProvider, String realm) {
        super(authProvider, HTTPAuthorizationHandler.Type.BASIC, realm);
    }

    @Override
    public Future<User> authenticate(RoutingContext context2) {
        return this.parseAuthorization(context2).compose(header -> {
            String spass;
            String suser;
            try {
                String decoded = new String(Utils.base64Decode(header), StandardCharsets.UTF_8);
                int colonIdx = decoded.indexOf(":");
                if (colonIdx != -1) {
                    suser = decoded.substring(0, colonIdx);
                    spass = decoded.substring(colonIdx + 1);
                } else {
                    suser = decoded;
                    spass = null;
                }
            }
            catch (RuntimeException e) {
                return Future.failedFuture(new HttpException(400, (Throwable)e));
            }
            SecurityAudit audit = ((RoutingContextInternal)context2).securityAudit();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(suser, spass);
            audit.credentials(credentials);
            return this.authProvider.authenticate(new UsernamePasswordCredentials(suser, spass)).andThen(result2 -> audit.audit(Marker.AUTHENTICATION, result2.succeeded())).recover(err -> Future.failedFuture(new HttpException(401, (Throwable)err)));
        });
    }
}

