/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.cache;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.CachingWebClientOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.cache.CacheControl;
import io.vertx.ext.web.client.impl.cache.CacheKey;
import io.vertx.ext.web.client.impl.cache.CacheVariationsKey;
import io.vertx.ext.web.client.impl.cache.CachedHttpResponse;
import io.vertx.ext.web.client.impl.cache.Vary;
import io.vertx.ext.web.client.spi.CacheStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheInterceptor
implements Handler<HttpContext<?>> {
    private static final String IS_CACHE_DISPATCH = "cache.dispatch";
    private static final String RESPONSE_TO_REVALIDATE = "cache.response_to_revalidate";
    private static final String IS_CACHE_REVALIDATION = "cache.revalidation";
    private final CacheStore publicCacheStore;
    private final CachingWebClientOptions options;
    private final Map<CacheVariationsKey, Set<Vary>> variationsRegistry;

    public CacheInterceptor(CacheStore store, CachingWebClientOptions options2) {
        this.publicCacheStore = store;
        this.options = options2;
        this.variationsRegistry = new ConcurrentHashMap<CacheVariationsKey, Set<Vary>>();
    }

    @Override
    public void handle(HttpContext<?> context2) {
        if (context2.get(IS_CACHE_REVALIDATION) == Boolean.TRUE) {
            switch (context2.phase()) {
                case DISPATCH_RESPONSE: {
                    this.processResponse(context2, null).onComplete(ar -> {});
                    break;
                }
                default: {
                    context2.next();
                    break;
                }
            }
        } else {
            switch (context2.phase()) {
                case CREATE_REQUEST: {
                    this.handleCreateRequest(context2);
                    break;
                }
                case DISPATCH_RESPONSE: {
                    this.handleDispatchResponse(context2);
                    break;
                }
                default: {
                    context2.next();
                }
            }
        }
    }

    private void handleCreateRequest(HttpContext<Buffer> context2) {
        Vary variation;
        RequestOptions request = context2.requestOptions();
        if (!this.options.getCachedMethods().contains(request.getMethod()) || (variation = this.selectVariation(request)) == null) {
            context2.next();
            return;
        }
        Promise promise = Promise.promise();
        CacheKey key = new CacheKey(request, variation);
        if (context2.privateCacheStore() != null) {
            context2.privateCacheStore().get(key).onSuccess(cached -> {
                if (cached == null) {
                    this.publicCacheStore.get(key).onComplete(promise);
                } else {
                    promise.complete(cached);
                }
            });
        } else {
            this.publicCacheStore.get(key).onComplete(promise);
        }
        promise.future().map(cached -> this.respondFromCache(context2, (CachedHttpResponse)cached)).onComplete(ar -> {
            if (ar.succeeded() && ((Optional)ar.result()).isPresent()) {
                context2.set(IS_CACHE_DISPATCH, true);
                context2.dispatchResponse((HttpResponse)((Optional)ar.result()).get());
            } else {
                context2.next();
            }
        });
    }

    private void handleDispatchResponse(HttpContext<Buffer> context2) {
        if (context2.get(IS_CACHE_DISPATCH) == Boolean.TRUE) {
            context2.next();
            return;
        }
        CachedHttpResponse responseToValidate = (CachedHttpResponse)((Object)context2.get(RESPONSE_TO_REVALIDATE));
        if (responseToValidate != null) {
            this.processRevalidationResponse(context2, responseToValidate).onComplete(ar -> {
                if (ar.succeeded()) {
                    context2.response((HttpResponse)ar.result());
                }
                context2.next();
            });
        } else {
            this.processResponse(context2, null).onComplete(ar -> context2.next());
        }
    }

    private Vary selectVariation(RequestOptions request) {
        CacheVariationsKey key = new CacheVariationsKey(request);
        Set possibleVariations = this.variationsRegistry.getOrDefault(key, Collections.emptySet());
        for (Vary variation : possibleVariations) {
            if (!variation.matchesRequest(request)) continue;
            return variation;
        }
        return null;
    }

    private Future<HttpResponse<Buffer>> processResponse(HttpContext<Buffer> context2, CachedHttpResponse cachedResponse) {
        HttpResponse<Buffer> response2 = context2.response();
        if (this.options.getCachedStatusCodes().contains(response2.statusCode())) {
            return this.cacheResponse(context2, response2).map(response2);
        }
        if (cachedResponse != null && cachedResponse.useStaleIfError()) {
            return Future.succeededFuture(cachedResponse.rehydrate());
        }
        return Future.succeededFuture(response2);
    }

    private Optional<HttpResponse<Buffer>> respondFromCache(HttpContext<Buffer> context2, CachedHttpResponse response2) {
        if (response2 == null) {
            return Optional.empty();
        }
        HttpResponse<Buffer> result2 = response2.rehydrate();
        result2.headers().set(HttpHeaders.AGE, (CharSequence)Long.toString(response2.age()));
        if (response2.getCacheControl().noCache()) {
            this.markForRevalidation(context2, response2);
            return Optional.empty();
        }
        if (response2.isFresh()) {
            return Optional.of(result2);
        }
        if (response2.useStaleWhileRevalidate()) {
            HttpContext<Buffer> duplicate = context2.duplicate();
            duplicate.set(IS_CACHE_REVALIDATION, true);
            duplicate.prepareRequest(context2.request(), context2.contentType(), context2.body());
            return Optional.of(result2);
        }
        this.markForRevalidation(context2, response2);
        return Optional.empty();
    }

    private void markForRevalidation(HttpContext<?> context2, CachedHttpResponse response2) {
        String etag = response2.getCacheControl().getEtag();
        if (etag != null) {
            context2.requestOptions().putHeader(HttpHeaders.IF_NONE_MATCH, (CharSequence)etag);
        }
        context2.set(RESPONSE_TO_REVALIDATE, response2);
    }

    private Future<HttpResponse<Buffer>> processRevalidationResponse(HttpContext<Buffer> context2, CachedHttpResponse cachedResponse) {
        if (context2.response().statusCode() == 304) {
            return this.cacheResponse(context2, cachedResponse.rehydrate());
        }
        return this.processResponse(context2, cachedResponse);
    }

    private Future<HttpResponse<Buffer>> cacheResponse(HttpContext<?> context2, HttpResponse<Buffer> response2) {
        HttpRequest<?> request = context2.request();
        CacheControl cacheControl = CacheControl.parse(response2.headers());
        if (!cacheControl.isCacheable()) {
            return Future.succeededFuture(response2);
        }
        if (cacheControl.isPrivate() && context2.privateCacheStore() == null) {
            return Future.succeededFuture(response2);
        }
        if (cacheControl.isVarying() && !this.options.isVaryCachingEnabled()) {
            return Future.succeededFuture(response2);
        }
        CacheVariationsKey variationsKey = new CacheVariationsKey(context2.requestOptions());
        Vary variation = new Vary(request.headers(), response2.headers());
        this.registerVariation(variationsKey, variation);
        CacheKey key = new CacheKey(context2.requestOptions(), variation);
        CachedHttpResponse cachedResponse = CachedHttpResponse.wrap(response2, cacheControl);
        if (cacheControl.isPrivate()) {
            return context2.privateCacheStore().set(key, cachedResponse).map(response2);
        }
        return this.publicCacheStore.set(key, cachedResponse).map(response2);
    }

    private void registerVariation(CacheVariationsKey variationsKey, Vary variation) {
        Set existing = this.variationsRegistry.getOrDefault(variationsKey, Collections.emptySet());
        HashSet updated = new HashSet(existing);
        updated.add(variation);
        this.variationsRegistry.put(variationsKey, updated);
    }
}

