/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.net.Address;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.ClientUri;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.WebClientInternal;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import io.vertx.uritemplate.ExpandOptions;
import io.vertx.uritemplate.UriTemplate;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WebClientBase<C extends WebClientBase<C>>
implements WebClientInternal {
    final HttpClient client;
    final WebClientOptions options;
    final List<Handler<HttpContext<?>>> interceptors;

    public WebClientBase(HttpClient client, WebClientOptions options2) {
        options2 = new WebClientOptions(options2);
        if (options2.getTemplateExpandOptions() == null) {
            options2.setTemplateExpandOptions(new ExpandOptions());
        }
        this.client = client;
        this.options = options2;
        this.interceptors = new CopyOnWriteArrayList();
    }

    WebClientBase(WebClientBase webClient) {
        this.client = webClient.client;
        this.options = new WebClientOptions(webClient.options);
        this.interceptors = new CopyOnWriteArrayList(webClient.interceptors);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String requestURI) {
        return this.request(method, serverAddress, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, UriTemplate requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, BodyCodecImpl.BUFFER, this.options.isFollowRedirects(), WebClientBase.buildProxyOptions(this.options), WebClientBase.buildHeaders(this.options));
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, RequestOptions requestOptions) {
        String host;
        Integer port = requestOptions.getPort();
        if (port == null) {
            port = this.options.getDefaultPort();
        }
        if ((host = requestOptions.getHost()) == null) {
            host = this.options.getDefaultHost();
        }
        Address address = serverAddress != null ? serverAddress : requestOptions.getServer();
        HttpRequestImpl<Buffer> request = new HttpRequestImpl<Buffer>(this, method, address, this.options.isSsl(), port, host, requestOptions.getURI(), BodyCodecImpl.BUFFER, this.options.isFollowRedirects(), WebClientBase.buildProxyOptions(this.options), WebClientBase.buildHeaders(this.options));
        request.ssl(requestOptions.isSsl());
        if (requestOptions.getTimeout() >= 0L) {
            request.timeout(requestOptions.getTimeout());
        }
        if (requestOptions.getConnectTimeout() >= 0L) {
            request.connectTimeout(requestOptions.getConnectTimeout());
        }
        if (requestOptions.getIdleTimeout() >= 0L) {
            request.idleTimeout(requestOptions.getIdleTimeout());
        }
        request.followRedirects(requestOptions.getFollowRedirects());
        ProxyOptions proxyOptions = requestOptions.getProxyOptions();
        if (proxyOptions != null) {
            request.proxy(new ProxyOptions(proxyOptions));
        }
        request.traceOperation(requestOptions.getTraceOperation());
        return requestOptions.getHeaders() == null ? request : request.putHeaders(requestOptions.getHeaders());
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String host, String requestURI) {
        return this.request(method, serverAddress, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String host, UriTemplate requestURI) {
        return this.request(method, serverAddress, this.options.getDefaultPort(), host, requestURI);
    }

    public HttpRequestImpl<Buffer> request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), port, host, requestURI, BodyCodecImpl.BUFFER, this.options.isFollowRedirects(), WebClientBase.buildProxyOptions(this.options), WebClientBase.buildHeaders(this.options));
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, int port, String host, UriTemplate requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), port, host, requestURI, BodyCodecImpl.BUFFER, this.options.isFollowRedirects(), WebClientBase.buildProxyOptions(this.options), WebClientBase.buildHeaders(this.options));
    }

    @Override
    public HttpRequest<Buffer> requestAbs(HttpMethod method, SocketAddress serverAddress, String surl) {
        ClientUri curi;
        try {
            curi = ClientUri.parse(surl);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new VertxException(e);
        }
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, curi.ssl, curi.port, curi.host, curi.uri, BodyCodecImpl.BUFFER, this.options.isFollowRedirects(), WebClientBase.buildProxyOptions(this.options), WebClientBase.buildHeaders(this.options));
    }

    @Override
    public HttpRequest<Buffer> requestAbs(HttpMethod method, SocketAddress serverAddress, UriTemplate absoluteURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, absoluteURI, BodyCodecImpl.BUFFER, this.options.isFollowRedirects(), WebClientBase.buildProxyOptions(this.options), WebClientBase.buildHeaders(this.options));
    }

    public C addInterceptor(Handler<HttpContext<?>> interceptor) {
        if (this.interceptors.stream().anyMatch(i -> i.getClass() == interceptor.getClass())) {
            throw new IllegalStateException(String.format("Client already contains a %s interceptor", interceptor.getClass()));
        }
        this.interceptors.add(interceptor);
        return (C)this;
    }

    @Override
    public <T> HttpContext<T> createContext(ContextInternal context2) {
        HttpClientInternal client = (HttpClientInternal)this.client;
        return new HttpContext(context2, client, this.options, this.interceptors, context2.promise());
    }

    @Override
    public Future<Boolean> updateSSLOptions(ClientSSLOptions options2, boolean force) {
        HttpClientInternal client = (HttpClientInternal)this.client;
        return client.updateSSLOptions(options2, force);
    }

    @Override
    public void close() {
        this.client.close();
    }

    private static MultiMap buildHeaders(WebClientOptions options2) {
        if (options2.isUserAgentEnabled()) {
            return HttpHeaders.set(HttpHeaders.USER_AGENT, (CharSequence)options2.getUserAgent());
        }
        return HttpHeaders.headers();
    }

    private static ProxyOptions buildProxyOptions(WebClientOptions options2) {
        if (options2.getProxyOptions() != null) {
            return new ProxyOptions(options2.getProxyOptions());
        }
        return null;
    }
}

