/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientSessionAware;
import io.vertx.ext.web.client.spi.CookieStore;
import java.net.URI;
import java.util.List;

public class SessionAwareInterceptor
implements Handler<HttpContext<?>> {
    private final WebClientSessionAware parentClient;

    public SessionAwareInterceptor(WebClientSessionAware clientSessionAware) {
        this.parentClient = clientSessionAware;
    }

    @Override
    public void handle(HttpContext<?> context2) {
        switch (context2.phase()) {
            case CREATE_REQUEST: {
                this.createRequest(context2);
                break;
            }
            case FOLLOW_REDIRECT: {
                this.processRedirectCookies(context2);
                break;
            }
            case DISPATCH_RESPONSE: {
                this.processResponse(context2);
                break;
            }
        }
        context2.next();
    }

    private void createRequest(HttpContext<?> context2) {
        Iterable<Cookie> cookies;
        String encodedCookies;
        RequestOptions request = context2.requestOptions();
        RequestOptions requestOptions = context2.requestOptions();
        MultiMap headers = requestOptions.getHeaders();
        if (headers == null) {
            headers = HttpHeaders.headers();
            requestOptions.setHeaders(headers);
        }
        headers.addAll(this.parentClient.headers());
        String domain = context2.request().virtualHost();
        if (domain == null) {
            domain = requestOptions.getHost();
        }
        if ((encodedCookies = ClientCookieEncoder.STRICT.encode(cookies = this.parentClient.cookieStore().get(request.isSsl(), domain, request.getURI()))) != null) {
            headers.add(HttpHeaders.COOKIE, (CharSequence)encodedCookies);
        }
    }

    private void processRedirectCookies(HttpContext<?> context2) {
        this.processRedirectResponse(context2);
        this.prepareRedirectRequest(context2);
    }

    private void processRedirectResponse(HttpContext<?> context2) {
        List<String> cookieHeaders = context2.clientResponse().cookies();
        if (cookieHeaders == null) {
            return;
        }
        RequestOptions originalRequest = context2.requestOptions();
        CookieStore cookieStore = this.parentClient.cookieStore();
        String domain = URI.create(context2.clientResponse().request().absoluteURI()).getHost();
        if (domain.equals(originalRequest.getHost()) && context2.request().virtualHost() != null) {
            domain = context2.request().virtualHost();
        }
        String finalDomain = domain;
        cookieHeaders.forEach(header -> {
            Cookie cookie = ClientCookieDecoder.STRICT.decode((String)header);
            if (cookie != null) {
                if (cookie.domain() == null) {
                    cookie.setDomain(finalDomain);
                }
                cookieStore.put(cookie);
            }
        });
    }

    private void prepareRedirectRequest(HttpContext<?> context2) {
        RequestOptions redirectRequest = context2.requestOptions();
        RequestOptions originalRequest = context2.requestOptions();
        String redirectHost = redirectRequest.getHost();
        String domain = redirectHost.equals(originalRequest.getHost()) && context2.request().virtualHost() != null ? context2.request().virtualHost() : redirectHost;
        String path = SessionAwareInterceptor.parsePath(redirectRequest.getURI());
        Iterable<Cookie> cookies = this.parentClient.cookieStore().get(originalRequest.isSsl(), domain, path);
        String encodedCookies = ClientCookieEncoder.STRICT.encode(cookies);
        if (encodedCookies != null) {
            redirectRequest.putHeader(HttpHeaders.COOKIE, (CharSequence)encodedCookies);
        }
    }

    private static String parsePath(String uri) {
        int i;
        if (uri.length() == 0) {
            return "";
        }
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    private void processResponse(HttpContext<?> context2) {
        List<String> cookieHeaders = context2.response().cookies();
        if (cookieHeaders == null) {
            return;
        }
        RequestOptions request = context2.requestOptions();
        CookieStore cookieStore = this.parentClient.cookieStore();
        cookieHeaders.forEach(header -> {
            Cookie cookie = ClientCookieDecoder.STRICT.decode((String)header);
            if (cookie != null) {
                if (cookie.domain() == null) {
                    cookie.setDomain(context2.request().virtualHost() != null ? context2.request().virtualHost() : request.getHost());
                }
                cookieStore.put(cookie);
            }
        });
    }
}

