/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.Oauth2WebClientAware;
import java.util.HashSet;
import java.util.Set;

public class OAuth2AwareInterceptor
implements Handler<HttpContext<?>> {
    private final Set<HttpContext<?>> dejaVu = new HashSet();
    private final Oauth2WebClientAware parentClient;

    public OAuth2AwareInterceptor(Oauth2WebClientAware webClientOauth2Aware) {
        this.parentClient = webClientOauth2Aware;
    }

    @Override
    public void handle(HttpContext<?> context2) {
        switch (context2.phase()) {
            case CREATE_REQUEST: {
                this.createRequest(context2).onFailure(context2::fail).onSuccess(done -> context2.next());
                break;
            }
            case DISPATCH_RESPONSE: {
                this.processResponse(context2);
                break;
            }
            default: {
                context2.next();
            }
        }
    }

    private void processResponse(HttpContext<?> context2) {
        switch (context2.response().statusCode()) {
            case 401: {
                if (!this.parentClient.isRenewTokenOnForbidden() || this.dejaVu.contains(context2)) {
                    this.dejaVu.remove(context2);
                    context2.next();
                    break;
                }
                this.dejaVu.add(context2);
                this.parentClient.oauth2Auth().authenticate(this.parentClient.getCredentials()).onSuccess(userResult -> {
                    this.parentClient.setUser((User)userResult);
                    context2.createRequest(context2.requestOptions());
                }).onFailure(err -> {
                    this.dejaVu.remove(context2);
                    this.parentClient.setUser(null);
                    context2.fail((Throwable)err);
                });
                break;
            }
            default: {
                this.dejaVu.remove(context2);
                context2.next();
            }
        }
    }

    private Future<Void> createRequest(HttpContext<?> context2) {
        Promise promise = Promise.promise();
        if (this.parentClient.getCredentials() != null) {
            if (this.parentClient.getUser() != null) {
                if (this.parentClient.getUser().expired(this.parentClient.getLeeway())) {
                    this.parentClient.oauth2Auth().refresh(this.parentClient.getUser()).onSuccess(userResult -> {
                        this.parentClient.setUser((User)userResult);
                        context2.requestOptions().putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("Bearer " + userResult.principal().getString("access_token")));
                        promise.complete();
                    }).onFailure(error2 -> this.parentClient.oauth2Auth().authenticate(this.parentClient.getCredentials()).onSuccess(userResult -> {
                        this.parentClient.setUser((User)userResult);
                        context2.requestOptions().putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("Bearer " + userResult.principal().getString("access_token")));
                        promise.complete();
                    }).onFailure(errorAuth -> {
                        this.parentClient.setUser(null);
                        promise.fail((Throwable)errorAuth);
                    }));
                } else {
                    context2.requestOptions().putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("Bearer " + this.parentClient.getUser().principal().getString("access_token")));
                    promise.complete();
                }
            } else {
                this.parentClient.oauth2Auth().authenticate(this.parentClient.getCredentials()).onSuccess(userResult -> {
                    this.parentClient.setUser((User)userResult);
                    context2.requestOptions().putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("Bearer " + userResult.principal().getString("access_token")));
                    promise.complete();
                }).onFailure(promise::fail);
            }
        } else {
            promise.fail("Missing client credentials");
        }
        return promise.future();
    }
}

