/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.MimeMapping;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.Json;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.ParsedHeaderValues;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.UserContext;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.List;
import java.util.Map;

@VertxGen
public interface RoutingContext {
    @CacheReturn
    public HttpServerRequest request();

    @CacheReturn
    public HttpServerResponse response();

    public void next();

    public void fail(int var1);

    public void fail(Throwable var1);

    public void fail(int var1, Throwable var2);

    @Fluent
    public RoutingContext put(String var1, Object var2);

    public <T> @Nullable T get(String var1);

    public <T> T get(String var1, T var2);

    public <T> @Nullable T remove(String var1);

    @GenIgnore(value={"permitted-type"})
    public <T> Map<String, T> data();

    @CacheReturn
    public Vertx vertx();

    public @Nullable String mountPoint();

    public @Nullable Route currentRoute();

    public String normalizedPath();

    public RequestBody body();

    public List<FileUpload> fileUploads();

    public void cancelAndCleanupFileUploads();

    public @Nullable Session session();

    public boolean isSessionAccessed();

    public UserContext userContext();

    default public @Nullable User user() {
        return this.userContext().get();
    }

    @CacheReturn
    public @Nullable Throwable failure();

    @CacheReturn
    public int statusCode();

    public @Nullable String getAcceptableContentType();

    @CacheReturn
    public ParsedHeaderValues parsedHeaders();

    public int addHeadersEndHandler(Handler<Void> var1);

    public boolean removeHeadersEndHandler(int var1);

    public int addBodyEndHandler(Handler<Void> var1);

    public boolean removeBodyEndHandler(int var1);

    @GenIgnore(value={"permitted-type"})
    public int addEndHandler(Handler<AsyncResult<Void>> var1);

    public boolean removeEndHandler(int var1);

    public boolean failed();

    public void setAcceptableContentType(@Nullable String var1);

    default public void reroute(String path) {
        this.reroute(this.request().method(), path);
    }

    public void reroute(HttpMethod var1, String var2);

    @CacheReturn
    default public List<LanguageHeader> acceptableLanguages() {
        return this.parsedHeaders().acceptLanguage();
    }

    @CacheReturn
    default public LanguageHeader preferredLanguage() {
        List<LanguageHeader> acceptableLanguages = this.acceptableLanguages();
        return acceptableLanguages.size() > 0 ? acceptableLanguages.get(0) : null;
    }

    public Map<String, String> pathParams();

    public @Nullable String pathParam(String var1);

    public MultiMap queryParams();

    @GenIgnore(value={"permitted-type"})
    public MultiMap queryParams(Charset var1);

    public List<String> queryParam(String var1);

    @Fluent
    default public RoutingContext attachment(String filename) {
        String contentType;
        if (filename != null && (contentType = MimeMapping.mimeTypeForFilename(filename)) != null) {
            this.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
        }
        this.response().putHeader(HttpHeaders.CONTENT_DISPOSITION, (CharSequence)("attachment; filename=" + filename));
        return this;
    }

    default public Future<Void> redirect(String url) {
        if ("back".equals(url) && (url = this.request().getHeader(HttpHeaders.REFERER)) == null) {
            url = "/";
        }
        this.response().putHeader(HttpHeaders.LOCATION, (CharSequence)url);
        int status = this.response().getStatusCode();
        if (status < 300 || status >= 400) {
            this.response().setStatusCode(302);
        }
        return this.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; charset=utf-8").end("Redirecting to " + url + ".");
    }

    default public Future<Void> json(Object json2) {
        HttpServerResponse res = this.response();
        boolean hasContentType = res.headers().contains(HttpHeaders.CONTENT_TYPE);
        if (json2 == null) {
            if (!hasContentType) {
                res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            }
            return res.end("null");
        }
        try {
            Buffer buffer = Json.encodeToBuffer(json2);
            if (!hasContentType) {
                res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            }
            return res.end(buffer);
        }
        catch (EncodeException | UnsupportedOperationException e) {
            this.fail(e);
            return ((ContextInternal)this.vertx().getOrCreateContext()).failedFuture(e);
        }
    }

    @CacheReturn
    default public boolean is(String type2) {
        MIMEHeader contentType = this.parsedHeaders().contentType();
        if (contentType == null) {
            return false;
        }
        ParsableMIMEValue value = type2.indexOf(47) == -1 ? new ParsableMIMEValue("*/" + type2).forceParse() : new ParsableMIMEValue(type2).forceParse();
        return contentType.isMatchedBy(value);
    }

    default public boolean isFresh() {
        HttpMethod method = this.request().method();
        if (method != HttpMethod.GET && method != HttpMethod.HEAD) {
            return false;
        }
        int s = this.response().getStatusCode();
        if (s >= 200 && s < 300 || 304 == s) {
            return Utils.fresh(this);
        }
        return false;
    }

    @Fluent
    default public RoutingContext etag(String etag) {
        boolean quoted;
        boolean bl = quoted = etag.length() > 2 && (etag.charAt(0) == '\"' || etag.startsWith("W/\"")) && etag.charAt(etag.length() - 1) == '\"';
        if (!quoted) {
            this.response().putHeader(HttpHeaders.ETAG, (CharSequence)("\"" + etag + "\""));
        } else {
            this.response().putHeader(HttpHeaders.ETAG, (CharSequence)etag);
        }
        return this;
    }

    @Fluent
    @GenIgnore(value={"permitted-type"})
    default public RoutingContext lastModified(Instant instant) {
        this.response().putHeader(HttpHeaders.LAST_MODIFIED, (CharSequence)Utils.formatRFC1123DateTime(instant.toEpochMilli()));
        return this;
    }

    @Fluent
    default public RoutingContext lastModified(String instant) {
        this.response().putHeader(HttpHeaders.LAST_MODIFIED, (CharSequence)instant);
        return this;
    }

    default public Future<Void> end(String chunk) {
        return this.response().end(chunk);
    }

    default public Future<Void> end(Buffer buffer) {
        return this.response().end(buffer);
    }

    default public Future<Void> end() {
        return this.response().end();
    }
}

