/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.prng;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.prng.PRNG;
import java.util.Objects;

@VertxGen
public interface VertxContextPRNG {
    public static VertxContextPRNG current() {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        throw new IllegalStateException("Not running in a Vert.x Context.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GenIgnore
    public static VertxContextPRNG current(Context context2) {
        Objects.requireNonNull(context2, "context can not be null");
        try {
            String contextKey = "__vertx.VertxContextPRNG";
            PRNG random = (PRNG)context2.get("__vertx.VertxContextPRNG");
            if (random == null) {
                Context context3 = context2;
                synchronized (context3) {
                    random = (PRNG)context2.get("__vertx.VertxContextPRNG");
                    if (random == null) {
                        PRNG rand = random = new PRNG(context2.owner());
                        context2.put("__vertx.VertxContextPRNG", rand);
                    }
                }
            }
            return random;
        }
        catch (UnsupportedOperationException e) {
            Vertx vertx = context2.owner();
            if (vertx != null) {
                return new PRNG(vertx);
            }
            throw new IllegalStateException("Not running in a Vert.x Context.");
        }
    }

    public static VertxContextPRNG current(Vertx vertx) {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        Objects.requireNonNull(vertx, "vertx can not be null");
        return new PRNG(vertx);
    }

    public void close();

    @GenIgnore(value={"permitted-type"})
    public void nextBytes(byte[] var1);

    public String nextString(int var1);

    public int nextInt();

    public int nextInt(int var1);

    public boolean nextBoolean();

    public long nextLong();

    public float nextFloat();

    public double nextDouble();

    public double nextGaussian();
}

