/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.Authorizations;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class AuthorizationsImpl
implements Authorizations {
    private Map<String, Set<Authorization>> authorizations;

    @Override
    public synchronized Authorizations put(String providerId, Set<Authorization> _authorizations) {
        Objects.requireNonNull(providerId);
        Map<String, Set<Authorization>> authorizations = this.authorizations;
        if (authorizations == null) {
            if (_authorizations != null) {
                authorizations = new HashMap<String, Set<Authorization>>();
            }
        } else {
            authorizations = new HashMap<String, Set<Authorization>>(authorizations);
            if (_authorizations == null) {
                authorizations.remove(providerId);
            }
        }
        if (_authorizations != null) {
            authorizations.put(providerId, Collections.unmodifiableSet(_authorizations));
        }
        this.authorizations = authorizations;
        return this;
    }

    @Override
    public synchronized Authorizations putAll(Map<String, Set<Authorization>> authorizations) {
        Objects.requireNonNull(authorizations);
        this.authorizations = authorizations;
        return this;
    }

    @Override
    public synchronized Authorizations clear() {
        this.authorizations = null;
        return this;
    }

    @Override
    public boolean contains(String providerId) {
        return this.authorizations != null && this.authorizations.containsKey(providerId);
    }

    @Override
    public boolean isEmpty() {
        Map<String, Set<Authorization>> authorizations = this.authorizations;
        return authorizations == null || authorizations.isEmpty();
    }

    public boolean equals(Object obj) {
        Map<String, Set<Authorization>> authorizations = this.authorizations;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthorizationsImpl)) {
            return false;
        }
        AuthorizationsImpl other = (AuthorizationsImpl)obj;
        return Objects.equals(authorizations, other.authorizations);
    }

    public int hashCode() {
        Map<String, Set<Authorization>> authorizations = this.authorizations;
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Objects.hashCode(authorizations);
        return result2;
    }

    @Override
    public boolean verify(Authorization resolvedAuthorization) {
        Map<String, Set<Authorization>> authorizations = this.authorizations;
        if (authorizations == null) {
            return false;
        }
        for (Map.Entry<String, Set<Authorization>> kv : authorizations.entrySet()) {
            for (Authorization authorization : kv.getValue()) {
                if (!authorization.verify(resolvedAuthorization)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Authorizations forEach(BiConsumer<String, Authorization> consumer2) {
        Map<String, Set<Authorization>> authorizations = this.authorizations;
        if (authorizations == null) {
            return this;
        }
        for (Map.Entry<String, Set<Authorization>> kv : authorizations.entrySet()) {
            for (Authorization authorization : kv.getValue()) {
                consumer2.accept(kv.getKey(), authorization);
            }
        }
        return this;
    }

    @Override
    public Authorizations forEach(String providerId, Consumer<Authorization> consumer2) {
        Map<String, Set<Authorization>> authorizations = this.authorizations;
        if (authorizations == null) {
            return this;
        }
        authorizations.getOrDefault(providerId, Collections.emptySet()).forEach(consumer2);
        return this;
    }

    public String toString() {
        return this.authorizations == null ? "<empty>" : this.authorizations.toString();
    }
}

