/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.NotAuthorization;
import io.vertx.ext.auth.authorization.OrAuthorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.impl.AndAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.NotAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.OrAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.PermissionBasedAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.RoleBasedAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.WildcardPermissionBasedAuthorizationConverter;
import java.util.Objects;

public class AuthorizationConverter {
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_AUTHORIZATIONS = "authorizations";

    public static Authorization decode(JsonObject json2) throws IllegalArgumentException {
        Objects.requireNonNull(json2);
        switch (Objects.requireNonNull(json2.getString(FIELD_TYPE))) {
            case "and": {
                return AndAuthorizationConverter.decode(json2);
            }
            case "not": {
                return NotAuthorizationConverter.decode(json2);
            }
            case "or": {
                return OrAuthorizationConverter.decode(json2);
            }
            case "permission": {
                return PermissionBasedAuthorizationConverter.decode(json2);
            }
            case "role": {
                return RoleBasedAuthorizationConverter.decode(json2);
            }
            case "wildcard": {
                return WildcardPermissionBasedAuthorizationConverter.decode(json2);
            }
        }
        throw new IllegalArgumentException("Unsupported authorization " + json2.getString(FIELD_TYPE));
    }

    public static JsonObject encode(Authorization value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        if (value instanceof AndAuthorization) {
            return AndAuthorizationConverter.encode((AndAuthorization)value);
        }
        if (value instanceof NotAuthorization) {
            return NotAuthorizationConverter.encode((NotAuthorization)value);
        }
        if (value instanceof OrAuthorization) {
            return OrAuthorizationConverter.encode((OrAuthorization)value);
        }
        if (value instanceof PermissionBasedAuthorization) {
            return PermissionBasedAuthorizationConverter.encode((PermissionBasedAuthorization)value);
        }
        if (value instanceof RoleBasedAuthorization) {
            return RoleBasedAuthorizationConverter.encode((RoleBasedAuthorization)value);
        }
        if (value instanceof WildcardPermissionBasedAuthorization) {
            return WildcardPermissionBasedAuthorizationConverter.encode((WildcardPermissionBasedAuthorization)value);
        }
        throw new IllegalArgumentException("Unsupported authorization " + String.valueOf(value.getClass()));
    }
}

