/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AndAuthorizationImpl
implements AndAuthorization {
    private final List<Authorization> authorizations = new ArrayList<Authorization>();

    @Override
    public AndAuthorization addAuthorization(Authorization authorization) {
        this.authorizations.add(Objects.requireNonNull(authorization));
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AndAuthorizationImpl)) {
            return false;
        }
        AndAuthorizationImpl other = (AndAuthorizationImpl)obj;
        return Objects.equals(this.authorizations, other.authorizations);
    }

    @Override
    public List<Authorization> getAuthorizations() {
        return this.authorizations;
    }

    public int hashCode() {
        return Objects.hash(this.authorizations);
    }

    @Override
    public boolean match(AuthorizationContext context2) {
        Objects.requireNonNull(context2);
        for (Authorization authorization : this.authorizations) {
            if (authorization.match(context2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean verify(Authorization otherAuthorization) {
        Objects.requireNonNull(otherAuthorization);
        boolean match = false;
        if (otherAuthorization instanceof AndAuthorization) {
            block0: for (Authorization otherAndAuthorization : ((AndAuthorization)otherAuthorization).getAuthorizations()) {
                for (Authorization authorization : this.authorizations) {
                    if (!authorization.verify(otherAndAuthorization)) continue;
                    match = true;
                    continue block0;
                }
            }
        } else {
            for (Authorization authorization : this.authorizations) {
                if (!authorization.verify(otherAuthorization)) continue;
                match = true;
                break;
            }
            return match;
        }
        return match;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND(");
        for (int i = 0; i < this.authorizations.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.authorizations.get(i).toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

