/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.audit.impl;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authorization.Authorization;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SecurityAuditLogger
implements SecurityAudit {
    public static final Logger LOGGER = LoggerFactory.getLogger(SecurityAudit.class);
    private static final String FORMAT = System.getProperty("io.vertx.ext.auth.audit.format", "rfc5424");
    private static final String MASK = "********************************";
    private static final Set<String> MASKED = new HashSet<String>();
    private SocketAddress source;
    private SocketAddress destination;
    private String resource;
    private Credentials credentials;
    private User user;
    private Authorization authorization;
    private int status;

    private static String mask(String input) {
        int len = input.length();
        if (len > 32) {
            return "********************************...";
        }
        return MASK.substring(0, len);
    }

    private static void escapeNLFChars(StringBuilder sb, String value) {
        block10: for (char c : value.toCharArray()) {
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\u0085': {
                    sb.append("\\u0085");
                    continue block10;
                }
                case '\u000b': {
                    sb.append("\\u000B");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\u000C");
                    continue block10;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block10;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static boolean isEnabled() {
        return LOGGER.isInfoEnabled();
    }

    @Override
    public SecurityAudit source(SocketAddress address) {
        this.source = address;
        return this;
    }

    @Override
    public SecurityAudit destination(SocketAddress address) {
        this.destination = address;
        return this;
    }

    @Override
    public SecurityAudit resource(HttpVersion version, HttpMethod method, String path) {
        StringBuilder sb = new StringBuilder();
        switch (version) {
            case HTTP_1_0: {
                sb.append("HTTP/1.0");
                break;
            }
            case HTTP_1_1: {
                sb.append("HTTP/1.1");
                break;
            }
            case HTTP_2: {
                sb.append("HTTP/2.0");
            }
        }
        sb.append(' ');
        sb.append(method.name());
        sb.append(' ');
        sb.append(path);
        this.resource = sb.toString();
        return this;
    }

    @Override
    public SecurityAudit resource(String resource2) {
        this.resource = resource2;
        return this;
    }

    @Override
    public SecurityAudit credentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public SecurityAudit user(User user) {
        this.user = user;
        return this;
    }

    @Override
    public SecurityAudit authorization(Authorization authorization) {
        this.authorization = authorization;
        return this;
    }

    @Override
    public SecurityAudit status(int status) {
        this.status = status;
        return this;
    }

    @Override
    public void audit(Marker marker, boolean success2) {
        switch (FORMAT) {
            case "json": {
                this.auditJSON(marker, success2);
                break;
            }
            default: {
                this.auditRFC5424(marker, success2);
            }
        }
    }

    private void auditRFC5424(Marker marker, boolean success2) {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(marker.name());
        sb.append(" epoch=\"").append(System.currentTimeMillis()).append('\"');
        if (this.source != null) {
            if (this.source.isInetSocket()) {
                sb.append(" source=\"").append(this.source.host());
            } else {
                sb.append(" source=\"");
                SecurityAuditLogger.escapeNLFChars(sb, this.source.path());
            }
            sb.append('\"');
        }
        if (this.destination != null) {
            if (this.destination.isInetSocket()) {
                sb.append(" destination=\"").append(this.destination.host());
            } else {
                sb.append(" destination=\"");
                SecurityAuditLogger.escapeNLFChars(sb, this.destination.path());
            }
            sb.append('\"');
        }
        if (this.resource != null) {
            sb.append(" resource=\"");
            SecurityAuditLogger.escapeNLFChars(sb, this.resource);
            sb.append('\"');
        }
        switch (marker) {
            case AUTHENTICATION: {
                if (this.credentials == null) break;
                for (Map.Entry<String, Object> kv : this.credentials.toJson()) {
                    String key = kv.getKey();
                    sb.append(' ');
                    SecurityAuditLogger.escapeNLFChars(sb, key);
                    sb.append('=');
                    Object value = kv.getValue();
                    if (value == null) {
                        sb.append("null");
                        continue;
                    }
                    sb.append('\"');
                    if (MASKED.contains(key)) {
                        sb.append(SecurityAuditLogger.mask(value.toString()));
                    } else {
                        SecurityAuditLogger.escapeNLFChars(sb, value.toString());
                    }
                    sb.append('\"');
                }
                break;
            }
            case AUTHORIZATION: {
                String sub;
                if (this.user != null && (sub = this.user.subject()) != null) {
                    sb.append(" subject=\"");
                    SecurityAuditLogger.escapeNLFChars(sb, sub);
                    sb.append('\"');
                }
                if (this.authorization == null) break;
                sb.append(" authorization=\"");
                SecurityAuditLogger.escapeNLFChars(sb, this.authorization.toString());
                sb.append('\"');
                break;
            }
            case REQUEST: {
                sb.append(" status=").append(this.status);
            }
        }
        sb.append("] ").append(success2 ? "OK" : "FAIL");
        LOGGER.info(sb.toString());
    }

    private void auditJSON(Marker marker, boolean success2) {
        JsonObject json2 = new JsonObject();
        json2.put("marker", marker.name());
        json2.put("epoch", System.currentTimeMillis());
        if (this.source != null) {
            if (this.source.isInetSocket()) {
                json2.put("source", this.source.host());
            } else {
                json2.put("source", this.source.path());
            }
        }
        if (this.destination != null) {
            if (this.destination.isInetSocket()) {
                json2.put("destination", this.destination.host());
            } else {
                json2.put("destination", this.destination.path());
            }
        }
        if (this.resource != null) {
            json2.put("resource", this.resource);
        }
        switch (marker) {
            case AUTHENTICATION: {
                if (this.credentials == null) break;
                for (Map.Entry<String, Object> kv : this.credentials.toJson()) {
                    String key = kv.getKey();
                    Object value = kv.getValue();
                    if (value == null) continue;
                    if (MASKED.contains(key)) {
                        json2.put(key, SecurityAuditLogger.mask(value.toString()));
                        continue;
                    }
                    json2.put(key, value.toString());
                }
                break;
            }
            case AUTHORIZATION: {
                String sub;
                if (this.user != null && (sub = this.user.subject()) != null) {
                    json2.put("subject", sub);
                }
                if (this.authorization == null) break;
                json2.put("authorization", this.authorization.toString());
                break;
            }
            case REQUEST: {
                json2.put("status", this.status);
            }
        }
        json2.put("result", success2 ? "OK" : "FAIL");
        LOGGER.info(json2.encode());
    }

    static {
        Collections.addAll(MASKED, "password", "secret", "jwt", "nonce", "cnonce", "assertion", "token", "challenge");
    }
}

