/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptionsConverter;

@DataObject
@JsonGen(publicConverter=false)
public class PubSecKeyOptions {
    private String algorithm;
    private Buffer buffer;
    private String id;

    public PubSecKeyOptions() {
    }

    public PubSecKeyOptions(PubSecKeyOptions other) {
        this.algorithm = other.algorithm;
        this.buffer = other.buffer == null ? null : other.buffer.copy();
        this.id = other.getId();
    }

    public PubSecKeyOptions(JsonObject json2) {
        PubSecKeyOptionsConverter.fromJson(json2, this);
    }

    public JsonObject toJson() {
        JsonObject json2 = new JsonObject();
        PubSecKeyOptionsConverter.toJson(this, json2);
        return json2;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public PubSecKeyOptions setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    @GenIgnore(value={"permitted-type"})
    public PubSecKeyOptions setBuffer(String buffer) {
        this.buffer = Buffer.buffer(buffer, "UTF-8");
        return this;
    }

    public PubSecKeyOptions setBuffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public PubSecKeyOptions setId(String id) {
        this.id = id;
        return this;
    }
}

