/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import java.util.ArrayList;
import java.util.Map;

public class JWTOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, JWTOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "leeway": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLeeway(((Number)member.getValue()).intValue());
                    break;
                }
                case "ignoreExpiration": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setIgnoreExpiration((Boolean)member.getValue());
                    break;
                }
                case "algorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAlgorithm((String)member.getValue());
                    break;
                }
                case "header": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHeader(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "noTimestamp": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNoTimestamp((Boolean)member.getValue());
                    break;
                }
                case "expiresInSeconds": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setExpiresInSeconds(((Number)member.getValue()).intValue());
                    break;
                }
                case "expiresInMinutes": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setExpiresInMinutes(((Number)member.getValue()).intValue());
                    break;
                }
                case "audience": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list2 = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setAudience(list2);
                    break;
                }
                case "audiences": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addAudience((String)item2);
                        }
                    });
                    break;
                }
                case "issuer": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIssuer((String)member.getValue());
                    break;
                }
                case "subject": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSubject((String)member.getValue());
                    break;
                }
                case "nonceAlgorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setNonceAlgorithm((String)member.getValue());
                }
            }
        }
    }

    static void toJson(JWTOptions obj, JsonObject json2) {
        JWTOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(JWTOptions obj, Map<String, Object> json2) {
        json2.put("leeway", obj.getLeeway());
        json2.put("ignoreExpiration", obj.isIgnoreExpiration());
        if (obj.getAlgorithm() != null) {
            json2.put("algorithm", obj.getAlgorithm());
        }
        if (obj.getHeader() != null) {
            json2.put("header", obj.getHeader());
        }
        json2.put("noTimestamp", obj.isNoTimestamp());
        json2.put("expiresInSeconds", obj.getExpiresInSeconds());
        if (obj.getAudience() != null) {
            JsonArray array = new JsonArray();
            obj.getAudience().forEach(item2 -> array.add(item2));
            json2.put("audience", array);
        }
        if (obj.getIssuer() != null) {
            json2.put("issuer", obj.getIssuer());
        }
        if (obj.getSubject() != null) {
            json2.put("subject", obj.getSubject());
        }
        if (obj.getNonceAlgorithm() != null) {
            json2.put("nonceAlgorithm", obj.getNonceAlgorithm());
        }
    }
}

