/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.impl.transports.NioTransport;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.ThreadFactory;

public interface Transport {
    public static final int ACCEPTOR_EVENT_LOOP_GROUP = 0;
    public static final int IO_EVENT_LOOP_GROUP = 1;

    default public boolean supportsDomainSockets() {
        return false;
    }

    default public boolean supportFileRegion() {
        return true;
    }

    default public boolean isAvailable() {
        return true;
    }

    default public Throwable unavailabilityCause() {
        return null;
    }

    default public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            throw new IllegalArgumentException("Domain sockets require JDK 16 and above, or the usage of a native transport");
        }
        InetAddress ip = ((SocketAddressImpl)address).ipAddress();
        if (ip != null) {
            return new InetSocketAddress(ip, address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    default public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return SocketAddress.inetSocketAddress((InetSocketAddress)address);
        }
        return null;
    }

    public IoHandlerFactory ioHandlerFactory();

    default public EventLoopGroup eventLoopGroup(int type2, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        return new MultiThreadIoEventLoopGroup(nThreads, threadFactory, this.ioHandlerFactory());
    }

    public DatagramChannel datagramChannel();

    public DatagramChannel datagramChannel(InternetProtocolFamily var1);

    public ChannelFactory<? extends Channel> channelFactory(boolean var1);

    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean var1);

    default public void configure(DatagramChannel channel, DatagramSocketOptions options2) {
        if (options2.getSendBufferSize() != -1) {
            channel.config().setSendBufferSize(options2.getSendBufferSize());
        }
        if (options2.getReceiveBufferSize() != -1) {
            channel.config().setReceiveBufferSize(options2.getReceiveBufferSize());
            channel.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(options2.getReceiveBufferSize()));
        }
        channel.config().setOption(ChannelOption.SO_REUSEADDR, options2.isReuseAddress());
        if (options2.getTrafficClass() != -1) {
            channel.config().setTrafficClass(options2.getTrafficClass());
        }
        channel.config().setBroadcast(options2.isBroadcast());
        if (this instanceof NioTransport) {
            channel.config().setLoopbackModeDisabled(options2.isLoopbackModeDisabled());
            if (options2.getMulticastTimeToLive() != -1) {
                channel.config().setTimeToLive(options2.getMulticastTimeToLive());
            }
            if (options2.getMulticastNetworkInterface() != null) {
                try {
                    channel.config().setNetworkInterface(NetworkInterface.getByName(options2.getMulticastNetworkInterface()));
                }
                catch (SocketException e) {
                    throw new IllegalArgumentException("Could not find network interface with name " + options2.getMulticastNetworkInterface());
                }
            }
        }
    }

    default public void configure(ClientOptionsBase options2, int connectTimeout, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(ChannelOption.SO_REUSEADDR, options2.isReuseAddress());
            bootstrap.option(ChannelOption.TCP_NODELAY, options2.isTcpNoDelay());
            bootstrap.option(ChannelOption.SO_KEEPALIVE, options2.isTcpKeepAlive());
        }
        if (options2.getLocalAddress() != null) {
            bootstrap.localAddress(options2.getLocalAddress(), 0);
        }
        if (options2.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, options2.getSendBufferSize());
        }
        if (options2.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, options2.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options2.getReceiveBufferSize()));
        }
        if (options2.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, options2.getSoLinger());
        }
        if (options2.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, options2.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeout);
    }

    default public void configure(NetServerOptions options2, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(ChannelOption.SO_REUSEADDR, options2.isReuseAddress());
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, options2.isTcpKeepAlive());
            bootstrap.childOption(ChannelOption.TCP_NODELAY, options2.isTcpNoDelay());
        }
        if (options2.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, options2.getSendBufferSize());
        }
        if (options2.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, options2.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options2.getReceiveBufferSize()));
        }
        if (options2.getSoLinger() != -1) {
            bootstrap.childOption(ChannelOption.SO_LINGER, options2.getSoLinger());
        }
        if (options2.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, options2.getTrafficClass());
        }
        if (options2.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, options2.getAcceptBacklog());
        }
    }
}

