/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.dns;

import io.netty.resolver.AddressResolverGroup;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.impl.DefaultAddressResolverProvider;
import io.vertx.core.dns.impl.DnsAddressResolverProvider;
import io.vertx.core.impl.SysProps;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import java.net.InetSocketAddress;

public interface AddressResolverProvider {
    public static AddressResolverProvider factory(Vertx vertx, AddressResolverOptions options2) {
        try {
            if (!SysProps.DISABLE_DNS_RESOLVER.getBoolean()) {
                return DnsAddressResolverProvider.create((VertxInternal)vertx, options2);
            }
        }
        catch (Throwable e) {
            if (e instanceof VertxException) {
                throw e;
            }
            Logger logger = LoggerFactory.getLogger(AddressResolverProvider.class);
            logger.info("Using the default address resolver as the dns resolver could not be loaded");
        }
        return new DefaultAddressResolverProvider();
    }

    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions var1);

    public Future<Void> close();
}

