/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.context.storage;

import io.vertx.core.Context;
import io.vertx.core.impl.ContextLocalImpl;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.context.storage.AccessMode;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ContextLocal<T> {
    public static <T> ContextLocal<T> registerLocal(Class<T> type2) {
        return ContextLocalImpl.create(type2, Function.identity());
    }

    public static <T> ContextLocal<T> registerLocal(Class<T> type2, Function<T, T> duplicator) {
        return ContextLocalImpl.create(type2, duplicator);
    }

    default public T get(Context context2) {
        return this.get(context2, AccessMode.CONCURRENT);
    }

    default public T get(Context context2, Supplier<? extends T> initialValueSupplier) {
        return this.get(context2, AccessMode.CONCURRENT, initialValueSupplier);
    }

    default public void put(Context context2, T data2) {
        this.put(context2, AccessMode.CONCURRENT, data2);
    }

    default public void remove(Context context2) {
        this.put(context2, AccessMode.CONCURRENT, null);
    }

    default public T get(Context context2, AccessMode accessMode) {
        return ((ContextInternal)context2).getLocal(this, accessMode);
    }

    default public T get(Context context2, AccessMode accessMode, Supplier<? extends T> initialValueSupplier) {
        return ((ContextInternal)context2).getLocal(this, accessMode, initialValueSupplier);
    }

    default public void put(Context context2, AccessMode accessMode, T value) {
        ((ContextInternal)context2).putLocal(this, accessMode, value);
    }

    default public void remove(Context context2, AccessMode accessMode) {
        this.put(context2, accessMode, null);
    }
}

