/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.ClusterSerializable;
import java.util.Objects;

public class RegistrationInfo
implements ClusterSerializable {
    private String nodeId;
    private long seq;
    private boolean localOnly;

    public RegistrationInfo() {
    }

    public RegistrationInfo(String nodeId, long seq, boolean localOnly) {
        Objects.requireNonNull(nodeId, "nodeId is null");
        this.nodeId = nodeId;
        this.seq = seq;
        this.localOnly = localOnly;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public long seq() {
        return this.seq;
    }

    public boolean localOnly() {
        return this.localOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationInfo that = (RegistrationInfo)o;
        if (this.seq != that.seq) {
            return false;
        }
        if (this.localOnly != that.localOnly) {
            return false;
        }
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        int result2 = this.nodeId.hashCode();
        result2 = 31 * result2 + (int)(this.seq ^ this.seq >>> 32);
        result2 = 31 * result2 + (this.localOnly ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "RegistrationInfo{nodeId=" + this.nodeId + ", seq=" + this.seq + ", localOnly=" + this.localOnly + "}";
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        buffer.appendInt(this.nodeId.length()).appendString(this.nodeId);
        buffer.appendLong(this.seq);
        buffer.appendByte((byte)(this.localOnly ? 1 : 0));
    }

    @Override
    public int readFromBuffer(int start2, Buffer buffer) {
        int pos = start2;
        int len = buffer.getInt(pos);
        this.nodeId = buffer.getString(pos += 4, pos + len);
        this.seq = buffer.getLong(pos += len);
        this.localOnly = buffer.getByte(pos += 8) > 0;
        return ++pos;
    }
}

