/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.impl.LockInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class LocalAsyncLocks {
    private final ConcurrentMap<String, List<LockWaiter>> waitersMap = new ConcurrentHashMap<String, List<LockWaiter>>();

    public Future<Lock> acquire(ContextInternal context2, String name, long timeout2) {
        PromiseInternal<Lock> promise = context2.promise();
        LockWaiter lockWaiter = new LockWaiter(context2, name, timeout2, promise);
        List waiters = this.waitersMap.compute(name, (s, list2) -> {
            ArrayList<LockWaiter> result2;
            if (list2 != null) {
                result2 = new ArrayList(list2.size() + 1);
                result2.addAll((Collection<LockWaiter>)list2);
            } else {
                result2 = new ArrayList<LockWaiter>(1);
            }
            result2.add(lockWaiter);
            return result2;
        });
        if (waiters.size() == 1) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
        return promise.future();
    }

    private void nextWaiter(String lockName) {
        List waiters = this.waitersMap.compute(lockName, (s, list2) -> list2 == null || list2.size() == 1 ? null : new ArrayList(list2.subList(1, list2.size())));
        if (waiters != null) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
    }

    private class AsyncLock
    implements LockInternal {
        final String lockName;
        final AtomicBoolean invoked = new AtomicBoolean();

        AsyncLock(String lockName) {
            this.lockName = lockName;
        }

        @Override
        public void release() {
            if (this.invoked.compareAndSet(false, true)) {
                LocalAsyncLocks.this.nextWaiter(this.lockName);
            }
        }

        @Override
        public int waiters() {
            List waiters = (List)LocalAsyncLocks.this.waitersMap.get(this.lockName);
            return waiters == null ? 0 : waiters.size() - 1;
        }
    }

    private class LockWaiter {
        final ContextInternal context;
        final String lockName;
        final Promise<Lock> promise;
        final Long timerId;

        LockWaiter(ContextInternal context2, String lockName, long timeout2, Promise<Lock> promise) {
            this.lockName = lockName;
            this.promise = promise;
            this.context = context2;
            this.timerId = timeout2 != Long.MAX_VALUE ? Long.valueOf(context2.setTimer(timeout2, tid -> this.timeout())) : null;
        }

        void timeout() {
            LocalAsyncLocks.this.waitersMap.compute(this.lockName, (s, list2) -> {
                int idx;
                if (list2 == null || (idx = list2.indexOf(this)) == -1) {
                    return list2;
                }
                if (list2.size() == 1) {
                    return null;
                }
                int size2 = list2.size();
                ArrayList n = new ArrayList(size2 - 1);
                if (idx > 0) {
                    n.addAll(list2.subList(0, idx));
                }
                if (idx + 1 < size2) {
                    n.addAll(list2.subList(idx + 1, size2));
                }
                return n;
            });
            this.promise.fail("Timed out waiting to get lock");
        }

        void acquireLock() {
            if (this.timerId == null || this.context.owner().cancelTimer(this.timerId)) {
                this.promise.complete(new AsyncLock(this.lockName));
            } else {
                LocalAsyncLocks.this.nextWaiter(this.lockName);
            }
        }
    }
}

