/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TCPSSLOptions;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TCPSSLOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, TCPSSLOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "tcpNoDelay": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpNoDelay((Boolean)member.getValue());
                    break;
                }
                case "tcpKeepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "soLinger": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSoLinger(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "readIdleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReadIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "writeIdleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWriteIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIdleTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "ssl": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSsl((Boolean)member.getValue());
                    break;
                }
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addEnabledCipherSuite((String)item2);
                        }
                    });
                    break;
                }
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addCrlPath((String)item2);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addCrlValue(Buffer.fromJson((String)item2));
                        }
                    });
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseAlpn((Boolean)member.getValue());
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list2 = new LinkedHashSet<String>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setEnabledSecureTransportProtocols(list2);
                    break;
                }
                case "tcpFastOpen": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpFastOpen((Boolean)member.getValue());
                    break;
                }
                case "tcpCork": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpCork((Boolean)member.getValue());
                    break;
                }
                case "tcpQuickAck": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpQuickAck((Boolean)member.getValue());
                    break;
                }
                case "tcpUserTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTcpUserTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(TCPSSLOptions obj, JsonObject json2) {
        TCPSSLOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(TCPSSLOptions obj, Map<String, Object> json2) {
        JsonArray array;
        json2.put("tcpNoDelay", obj.isTcpNoDelay());
        json2.put("tcpKeepAlive", obj.isTcpKeepAlive());
        json2.put("soLinger", obj.getSoLinger());
        json2.put("idleTimeout", obj.getIdleTimeout());
        json2.put("readIdleTimeout", obj.getReadIdleTimeout());
        json2.put("writeIdleTimeout", obj.getWriteIdleTimeout());
        if (obj.getIdleTimeoutUnit() != null) {
            json2.put("idleTimeoutUnit", obj.getIdleTimeoutUnit().name());
        }
        json2.put("ssl", obj.isSsl());
        if (obj.getEnabledCipherSuites() != null) {
            array = new JsonArray();
            obj.getEnabledCipherSuites().forEach(item2 -> array.add(item2));
            json2.put("enabledCipherSuites", array);
        }
        if (obj.getCrlPaths() != null) {
            array = new JsonArray();
            obj.getCrlPaths().forEach(item2 -> array.add(item2));
            json2.put("crlPaths", array);
        }
        if (obj.getCrlValues() != null) {
            array = new JsonArray();
            obj.getCrlValues().forEach(item2 -> array.add(item2.toJson()));
            json2.put("crlValues", array);
        }
        json2.put("useAlpn", obj.isUseAlpn());
        if (obj.getEnabledSecureTransportProtocols() != null) {
            array = new JsonArray();
            obj.getEnabledSecureTransportProtocols().forEach(item2 -> array.add(item2));
            json2.put("enabledSecureTransportProtocols", array);
        }
        json2.put("tcpFastOpen", obj.isTcpFastOpen());
        json2.put("tcpCork", obj.isTcpCork());
        json2.put("tcpQuickAck", obj.isTcpQuickAck());
        json2.put("tcpUserTimeout", obj.getTcpUserTimeout());
        json2.put("sslHandshakeTimeout", obj.getSslHandshakeTimeout());
        if (obj.getSslHandshakeTimeoutUnit() != null) {
            json2.put("sslHandshakeTimeoutUnit", obj.getSslHandshakeTimeoutUnit().name());
        }
    }
}

