/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetworkOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.TCPSSLOptionsConverter;
import io.vertx.core.net.TrustOptions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public abstract class TCPSSLOptions
extends NetworkOptions {
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final int DEFAULT_SO_LINGER = -1;
    public static final boolean DEFAULT_SSL = false;
    public static final int DEFAULT_IDLE_TIMEOUT = 0;
    public static final TimeUnit DEFAULT_IDLE_TIMEOUT_TIME_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_READ_IDLE_TIMEOUT = 0;
    public static final int DEFAULT_WRITE_IDLE_TIMEOUT = 0;
    public static final SSLEngineOptions DEFAULT_SSL_ENGINE = null;
    public static final boolean DEFAULT_TCP_FAST_OPEN = false;
    public static final boolean DEFAULT_TCP_CORK = false;
    public static final boolean DEFAULT_TCP_QUICKACK = false;
    public static final int DEFAULT_TCP_USER_TIMEOUT = 0;
    private boolean tcpNoDelay;
    private boolean tcpKeepAlive;
    private int soLinger;
    private int idleTimeout;
    private int readIdleTimeout;
    private int writeIdleTimeout;
    private TimeUnit idleTimeoutUnit;
    private boolean ssl;
    private SSLEngineOptions sslEngineOptions;
    private SSLOptions sslOptions;
    private boolean tcpFastOpen;
    private boolean tcpCork;
    private boolean tcpQuickAck;
    private int tcpUserTimeout;
    private Set<String> enabledCipherSuites;
    private List<String> crlPaths;
    private List<Buffer> crlValues;

    public TCPSSLOptions() {
        this.init();
    }

    public TCPSSLOptions(TCPSSLOptions other) {
        super(other);
        this.tcpNoDelay = other.isTcpNoDelay();
        this.tcpKeepAlive = other.isTcpKeepAlive();
        this.soLinger = other.getSoLinger();
        this.idleTimeout = other.getIdleTimeout();
        this.idleTimeoutUnit = other.getIdleTimeoutUnit() != null ? other.getIdleTimeoutUnit() : DEFAULT_IDLE_TIMEOUT_TIME_UNIT;
        this.readIdleTimeout = other.getReadIdleTimeout();
        this.writeIdleTimeout = other.getWriteIdleTimeout();
        this.ssl = other.isSsl();
        this.sslEngineOptions = other.sslEngineOptions != null ? other.sslEngineOptions.copy() : null;
        this.tcpFastOpen = other.isTcpFastOpen();
        this.tcpCork = other.isTcpCork();
        this.tcpQuickAck = other.isTcpQuickAck();
        this.tcpUserTimeout = other.getTcpUserTimeout();
        SSLOptions sslOptions = other.sslOptions;
        if (sslOptions != null) {
            this.sslOptions = sslOptions.copy();
            if (this.sslOptions != null) {
                this.enabledCipherSuites = this.sslOptions.enabledCipherSuites;
                this.crlPaths = this.sslOptions.crlPaths;
                this.crlValues = this.sslOptions.crlValues;
            }
        }
    }

    public TCPSSLOptions(JsonObject json2) {
        super(json2);
        this.init();
        TCPSSLOptionsConverter.fromJson(json2, this);
        if (json2.containsKey("pemKeyCertOptions")) {
            this.setKeyCertOptions(new PemKeyCertOptions(json2.getJsonObject("pemKeyCertOptions")));
        } else if (json2.containsKey("keyStoreOptions")) {
            this.setKeyCertOptions(new JksOptions(json2.getJsonObject("keyStoreOptions")));
        } else if (json2.containsKey("pfxKeyCertOptions")) {
            this.setKeyCertOptions(new PfxOptions(json2.getJsonObject("pfxKeyCertOptions")));
        }
        if (json2.containsKey("pemTrustOptions")) {
            this.setTrustOptions(new PemTrustOptions(json2.getJsonObject("pemTrustOptions")));
        } else if (json2.containsKey("pfxTrustOptions")) {
            this.setTrustOptions(new PfxOptions(json2.getJsonObject("pfxTrustOptions")));
        } else if (json2.containsKey("trustStoreOptions")) {
            this.setTrustOptions(new JksOptions(json2.getJsonObject("trustStoreOptions")));
        }
        if (json2.containsKey("jdkSslEngineOptions")) {
            this.setSslEngineOptions(new JdkSSLEngineOptions(json2.getJsonObject("jdkSslEngineOptions")));
        } else if (json2.containsKey("openSslEngineOptions")) {
            this.setSslEngineOptions(new OpenSSLEngineOptions(json2.getJsonObject("openSslEngineOptions")));
        }
    }

    @Override
    public JsonObject toJson() {
        SSLEngineOptions engineOptions;
        JsonObject json2 = super.toJson();
        TCPSSLOptionsConverter.toJson(this, json2);
        if (this.sslOptions != null) {
            TrustOptions trustOptions;
            KeyCertOptions keyCertOptions = this.sslOptions.getKeyCertOptions();
            if (keyCertOptions != null) {
                if (keyCertOptions instanceof PemKeyCertOptions) {
                    json2.put("pemKeyCertOptions", ((PemKeyCertOptions)keyCertOptions).toJson());
                } else if (keyCertOptions instanceof JksOptions) {
                    json2.put("keyStoreOptions", ((JksOptions)keyCertOptions).toJson());
                } else if (keyCertOptions instanceof PfxOptions) {
                    json2.put("pfxKeyCertOptions", ((PfxOptions)keyCertOptions).toJson());
                }
            }
            if ((trustOptions = this.sslOptions.getTrustOptions()) instanceof PemTrustOptions) {
                json2.put("pemTrustOptions", ((PemTrustOptions)trustOptions).toJson());
            } else if (trustOptions instanceof PfxOptions) {
                json2.put("pfxTrustOptions", ((PfxOptions)trustOptions).toJson());
            } else if (trustOptions instanceof JksOptions) {
                json2.put("trustStoreOptions", ((JksOptions)trustOptions).toJson());
            }
        }
        if ((engineOptions = this.sslEngineOptions) != null) {
            if (engineOptions instanceof JdkSSLEngineOptions) {
                json2.put("jdkSslEngineOptions", ((JdkSSLEngineOptions)engineOptions).toJson());
            } else if (engineOptions instanceof OpenSSLEngineOptions) {
                json2.put("openSslEngineOptions", ((OpenSSLEngineOptions)engineOptions).toJson());
            }
        }
        return json2;
    }

    private void init() {
        this.tcpNoDelay = true;
        this.tcpKeepAlive = false;
        this.soLinger = -1;
        this.idleTimeout = 0;
        this.readIdleTimeout = 0;
        this.writeIdleTimeout = 0;
        this.idleTimeoutUnit = DEFAULT_IDLE_TIMEOUT_TIME_UNIT;
        this.ssl = false;
        this.sslEngineOptions = DEFAULT_SSL_ENGINE;
        this.tcpFastOpen = false;
        this.tcpCork = false;
        this.tcpQuickAck = false;
        this.tcpUserTimeout = 0;
        this.sslOptions = null;
    }

    protected SSLOptions getOrCreateSSLOptions() {
        if (this.sslOptions == null) {
            SSLOptions sSLOptions = this.sslOptions = this instanceof ClientOptionsBase ? new ClientSSLOptions() : new ServerSSLOptions();
            if (this.enabledCipherSuites != null) {
                this.sslOptions.enabledCipherSuites = this.enabledCipherSuites;
            } else {
                this.enabledCipherSuites = this.sslOptions.enabledCipherSuites;
            }
            if (this.crlPaths != null) {
                this.sslOptions.crlPaths = this.crlPaths;
            } else {
                this.crlPaths = this.sslOptions.crlPaths;
            }
            if (this.crlValues != null) {
                this.sslOptions.crlValues = this.crlValues;
            } else {
                this.crlValues = this.sslOptions.crlValues;
            }
        }
        return this.sslOptions;
    }

    @GenIgnore
    public SSLOptions getSslOptions() {
        return this.sslOptions;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public TCPSSLOptions setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public TCPSSLOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
        return this;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public TCPSSLOptions setSoLinger(int soLinger) {
        if (soLinger < 0 && soLinger != -1) {
            throw new IllegalArgumentException("soLinger must be >= 0");
        }
        this.soLinger = soLinger;
        return this;
    }

    public TCPSSLOptions setIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("idleTimeout must be >= 0");
        }
        this.idleTimeout = idleTimeout;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public TCPSSLOptions setReadIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("readIdleTimeout must be >= 0");
        }
        this.readIdleTimeout = idleTimeout;
        return this;
    }

    public int getReadIdleTimeout() {
        return this.readIdleTimeout;
    }

    public TCPSSLOptions setWriteIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("writeIdleTimeout must be >= 0");
        }
        this.writeIdleTimeout = idleTimeout;
        return this;
    }

    public int getWriteIdleTimeout() {
        return this.writeIdleTimeout;
    }

    public TCPSSLOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        this.idleTimeoutUnit = idleTimeoutUnit;
        return this;
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.idleTimeoutUnit;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public TCPSSLOptions setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    @GenIgnore
    public KeyCertOptions getKeyCertOptions() {
        SSLOptions o = this.sslOptions;
        return o != null ? o.getKeyCertOptions() : null;
    }

    @GenIgnore
    public TCPSSLOptions setKeyCertOptions(KeyCertOptions options2) {
        this.getOrCreateSSLOptions().setKeyCertOptions(options2);
        return this;
    }

    public TrustOptions getTrustOptions() {
        SSLOptions o = this.sslOptions;
        return o != null ? o.getTrustOptions() : null;
    }

    public TCPSSLOptions setTrustOptions(TrustOptions options2) {
        this.getOrCreateSSLOptions().setTrustOptions(options2);
        return this;
    }

    public TCPSSLOptions addEnabledCipherSuite(String suite) {
        this.getOrCreateSSLOptions().addEnabledCipherSuite(suite);
        return this;
    }

    public TCPSSLOptions removeEnabledCipherSuite(String suite) {
        this.getOrCreateSSLOptions().removeEnabledCipherSuite(suite);
        return this;
    }

    public Set<String> getEnabledCipherSuites() {
        if (this.enabledCipherSuites == null) {
            this.enabledCipherSuites = new LinkedHashSet<String>();
        }
        return this.enabledCipherSuites;
    }

    public List<String> getCrlPaths() {
        if (this.crlPaths == null) {
            this.crlPaths = new ArrayList<String>();
        }
        return this.crlPaths;
    }

    public TCPSSLOptions addCrlPath(String crlPath) throws NullPointerException {
        this.getOrCreateSSLOptions().addCrlPath(crlPath);
        return this;
    }

    public List<Buffer> getCrlValues() {
        if (this.crlValues == null) {
            this.crlValues = new ArrayList<Buffer>();
        }
        return this.crlValues;
    }

    public TCPSSLOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        this.getOrCreateSSLOptions().addCrlValue(crlValue);
        return this;
    }

    public boolean isUseAlpn() {
        SSLOptions o = this.sslOptions;
        return o != null && o.isUseAlpn();
    }

    public TCPSSLOptions setUseAlpn(boolean useAlpn) {
        this.getOrCreateSSLOptions().setUseAlpn(useAlpn);
        return this;
    }

    public SSLEngineOptions getSslEngineOptions() {
        return this.sslEngineOptions;
    }

    public TCPSSLOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        this.sslEngineOptions = sslEngineOptions;
        return this;
    }

    public TCPSSLOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        this.getOrCreateSSLOptions().setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
        return this;
    }

    public TCPSSLOptions addEnabledSecureTransportProtocol(String protocol) {
        this.getOrCreateSSLOptions().addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public TCPSSLOptions removeEnabledSecureTransportProtocol(String protocol) {
        this.getOrCreateSSLOptions().removeEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public boolean isTcpFastOpen() {
        return this.tcpFastOpen;
    }

    public TCPSSLOptions setTcpFastOpen(boolean tcpFastOpen) {
        this.tcpFastOpen = tcpFastOpen;
        return this;
    }

    public boolean isTcpCork() {
        return this.tcpCork;
    }

    public TCPSSLOptions setTcpCork(boolean tcpCork) {
        this.tcpCork = tcpCork;
        return this;
    }

    public boolean isTcpQuickAck() {
        return this.tcpQuickAck;
    }

    public TCPSSLOptions setTcpQuickAck(boolean tcpQuickAck) {
        this.tcpQuickAck = tcpQuickAck;
        return this;
    }

    public int getTcpUserTimeout() {
        return this.tcpUserTimeout;
    }

    public TCPSSLOptions setTcpUserTimeout(int tcpUserTimeout) {
        this.tcpUserTimeout = tcpUserTimeout;
        return this;
    }

    public Set<String> getEnabledSecureTransportProtocols() {
        SSLOptions o = this.sslOptions;
        return o != null ? o.getEnabledSecureTransportProtocols() : new LinkedHashSet<String>(SSLOptions.DEFAULT_ENABLED_SECURE_TRANSPORT_PROTOCOLS);
    }

    public long getSslHandshakeTimeout() {
        SSLOptions o = this.sslOptions;
        return o != null ? o.getSslHandshakeTimeout() : 10L;
    }

    public TCPSSLOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        this.getOrCreateSSLOptions().setSslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    public TCPSSLOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        this.getOrCreateSSLOptions().setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
        return this;
    }

    public TimeUnit getSslHandshakeTimeoutUnit() {
        SSLOptions o = this.sslOptions;
        return o != null ? o.getSslHandshakeTimeoutUnit() : SSLOptions.DEFAULT_SSL_HANDSHAKE_TIMEOUT_TIME_UNIT;
    }

    @Override
    public TCPSSLOptions setLogActivity(boolean logEnabled) {
        return (TCPSSLOptions)super.setLogActivity(logEnabled);
    }

    @Override
    public TCPSSLOptions setActivityLogDataFormat(ByteBufFormat activityLogDataFormat) {
        return (TCPSSLOptions)super.setActivityLogDataFormat(activityLogDataFormat);
    }

    @Override
    public TCPSSLOptions setSendBufferSize(int sendBufferSize) {
        return (TCPSSLOptions)super.setSendBufferSize(sendBufferSize);
    }

    @Override
    public TCPSSLOptions setReceiveBufferSize(int receiveBufferSize) {
        return (TCPSSLOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public TCPSSLOptions setReuseAddress(boolean reuseAddress) {
        return (TCPSSLOptions)super.setReuseAddress(reuseAddress);
    }

    @Override
    public TCPSSLOptions setTrafficClass(int trafficClass) {
        return (TCPSSLOptions)super.setTrafficClass(trafficClass);
    }

    @Override
    public TCPSSLOptions setReusePort(boolean reusePort) {
        return (TCPSSLOptions)super.setReusePort(reusePort);
    }
}

