/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetworkOptions;
import java.util.Map;

public class NetworkOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, NetworkOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "sendBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSendBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "receiveBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReceiveBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "reuseAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReuseAddress((Boolean)member.getValue());
                    break;
                }
                case "trafficClass": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTrafficClass(((Number)member.getValue()).intValue());
                    break;
                }
                case "logActivity": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setLogActivity((Boolean)member.getValue());
                    break;
                }
                case "activityLogDataFormat": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setActivityLogDataFormat(ByteBufFormat.valueOf((String)member.getValue()));
                    break;
                }
                case "reusePort": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReusePort((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetworkOptions obj, JsonObject json2) {
        NetworkOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(NetworkOptions obj, Map<String, Object> json2) {
        json2.put("sendBufferSize", obj.getSendBufferSize());
        json2.put("receiveBufferSize", obj.getReceiveBufferSize());
        json2.put("reuseAddress", obj.isReuseAddress());
        json2.put("trafficClass", obj.getTrafficClass());
        json2.put("logActivity", obj.getLogActivity());
        if (obj.getActivityLogDataFormat() != null) {
            json2.put("activityLogDataFormat", obj.getActivityLogDataFormat().name());
        }
        json2.put("reusePort", obj.isReusePort());
    }
}

