/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.TrafficShapingOptions;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NetServerOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, NetServerOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "acceptBacklog": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setAcceptBacklog(((Number)member.getValue()).intValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "clientAuth": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientAuth(ClientAuth.valueOf((String)member.getValue()));
                    break;
                }
                case "sni": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSni((Boolean)member.getValue());
                    break;
                }
                case "useProxyProtocol": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseProxyProtocol((Boolean)member.getValue());
                    break;
                }
                case "proxyProtocolTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setProxyProtocolTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "proxyProtocolTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setProxyProtocolTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "trafficShapingOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setTrafficShapingOptions(new TrafficShapingOptions((JsonObject)member.getValue()));
                    break;
                }
                case "registerWriteHandler": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRegisterWriteHandler((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetServerOptions obj, JsonObject json2) {
        NetServerOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(NetServerOptions obj, Map<String, Object> json2) {
        json2.put("acceptBacklog", obj.getAcceptBacklog());
        json2.put("port", obj.getPort());
        if (obj.getHost() != null) {
            json2.put("host", obj.getHost());
        }
        if (obj.getClientAuth() != null) {
            json2.put("clientAuth", obj.getClientAuth().name());
        }
        json2.put("sni", obj.isSni());
        json2.put("useProxyProtocol", obj.isUseProxyProtocol());
        json2.put("proxyProtocolTimeout", obj.getProxyProtocolTimeout());
        if (obj.getProxyProtocolTimeoutUnit() != null) {
            json2.put("proxyProtocolTimeoutUnit", obj.getProxyProtocolTimeoutUnit().name());
        }
        if (obj.getTrafficShapingOptions() != null) {
            json2.put("trafficShapingOptions", obj.getTrafficShapingOptions().toJson());
        }
        json2.put("registerWriteHandler", obj.isRegisterWriteHandler());
    }
}

