/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.util.concurrent.TimeUnit;

@VertxGen
public interface NetServer
extends Measured {
    public NetServer connectHandler(@Nullable Handler<NetSocket> var1);

    @GenIgnore
    public Handler<NetSocket> connectHandler();

    public Future<NetServer> listen();

    default public Future<NetServer> listen(int port, String host) {
        return this.listen(new SocketAddressImpl(port, host));
    }

    default public Future<NetServer> listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    public Future<NetServer> listen(SocketAddress var1);

    @GenIgnore
    @Fluent
    public NetServer exceptionHandler(Handler<Throwable> var1);

    default public Future<Void> close() {
        return this.shutdown(0L, TimeUnit.SECONDS);
    }

    default public Future<Void> shutdown() {
        return this.shutdown(30L, TimeUnit.SECONDS);
    }

    public Future<Void> shutdown(long var1, TimeUnit var3);

    public int actualPort();

    default public Future<Boolean> updateSSLOptions(ServerSSLOptions options2) {
        return this.updateSSLOptions(options2, false);
    }

    public Future<Boolean> updateSSLOptions(ServerSSLOptions var1, boolean var2);

    public Future<Boolean> updateTrafficShapingOptions(TrafficShapingOptions var1);
}

