/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import java.util.ArrayList;
import java.util.Map;

public class NetClientOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, NetClientOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "hostnameVerificationAlgorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostnameVerificationAlgorithm((String)member.getValue());
                    break;
                }
                case "applicationLayerProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list2 = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setApplicationLayerProtocols(list2);
                    break;
                }
                case "registerWriteHandler": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRegisterWriteHandler((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetClientOptions obj, JsonObject json2) {
        NetClientOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(NetClientOptions obj, Map<String, Object> json2) {
        json2.put("reconnectAttempts", obj.getReconnectAttempts());
        json2.put("reconnectInterval", obj.getReconnectInterval());
        if (obj.getHostnameVerificationAlgorithm() != null) {
            json2.put("hostnameVerificationAlgorithm", obj.getHostnameVerificationAlgorithm());
        }
        if (obj.getApplicationLayerProtocols() != null) {
            JsonArray array = new JsonArray();
            obj.getApplicationLayerProtocols().forEach(item2 -> array.add(item2));
            json2.put("applicationLayerProtocols", array);
        }
        json2.put("registerWriteHandler", obj.isRegisterWriteHandler());
    }
}

