/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.HostAndPortImpl;

@DataObject
public interface HostAndPort {
    public static HostAndPort fromJson(JsonObject json2) {
        int port = json2.getInteger("port", -1);
        String host = json2.getString("host");
        if (host != null) {
            return HostAndPort.create(host, port);
        }
        return null;
    }

    public static HostAndPort create(String host, int port) {
        return new HostAndPortImpl(host, port);
    }

    public static HostAndPort parseAuthority(String string, int schemePort) {
        return HostAndPortImpl.parseAuthority(string, schemePort);
    }

    public static HostAndPort authority(String host, int port) {
        if (!HttpUtils.isValidHostAuthority(host)) {
            throw new IllegalArgumentException("Invalid authority host portion: " + host);
        }
        return new HostAndPortImpl(host, port);
    }

    public static HostAndPort authority(String host) {
        return HostAndPort.authority(host, -1);
    }

    public String host();

    public int port();

    default public JsonObject toJson() {
        JsonObject json2 = new JsonObject().put("host", this.host());
        int port = this.port();
        if (port > 0) {
            json2.put("port", port);
        }
        return json2;
    }
}

