/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.core.json.jackson.VertxModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DatabindCodec
extends JacksonCodec {
    private static final ObjectMapper mapper = new ObjectMapper(JacksonCodec.factory);

    private static void initialize() {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        VertxModule module = new VertxModule();
        mapper.registerModule(module);
    }

    public static ObjectMapper mapper() {
        return mapper;
    }

    @Override
    public <T> T fromValue(Object json2, Class<T> clazz) {
        Object value = mapper.convertValue(json2, clazz);
        if (clazz == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    public <T> T fromValue(Object json2, TypeReference<T> type2) {
        Object value = mapper.convertValue(json2, type2);
        if (type2.getType() == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    @Override
    public <T> T fromString(String str, Class<T> clazz) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(str), clazz);
    }

    public <T> T fromString(String str, TypeReference<T> typeRef) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(str), typeRef);
    }

    @Override
    public <T> T fromBuffer(Buffer buf, Class<T> clazz) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(buf), clazz);
    }

    public <T> T fromBuffer(Buffer buf, TypeReference<T> typeRef) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(buf), typeRef);
    }

    public static JsonParser createParser(BufferInternal buf) {
        try {
            return mapper.getFactory().createParser(new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static JsonParser createParser(String str) {
        try {
            return mapper.getFactory().createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type2) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = mapper.readValue(parser, type2);
            remaining = parser.nextToken();
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
        finally {
            DatabindCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type2 == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    private static <T> T fromParser(JsonParser parser, TypeReference<T> type2) throws DecodeException {
        Object value;
        try {
            value = mapper.readValue(parser, type2);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
        finally {
            DatabindCodec.close(parser);
        }
        if (type2.getType() == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        try {
            String result2 = pretty ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object) : mapper.writeValueAsString(object);
            return result2;
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        try {
            byte[] result2 = pretty ? mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(object) : mapper.writeValueAsBytes(object);
            return Buffer.buffer(result2);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    private static Object adapt(Object o) {
        try {
            if (o instanceof List) {
                List list2 = (List)o;
                return new JsonArray(list2);
            }
            if (o instanceof Map) {
                Map map2 = (Map)o;
                return new JsonObject(map2);
            }
            return o;
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage());
        }
    }

    static {
        DatabindCodec.initialize();
    }
}

