/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.tls;

import io.netty.handler.ssl.OpenSsl;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.tls.SslContextProvider;
import io.vertx.core.internal.tls.TrustAllOptions;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.spi.tls.SslContextFactory;
import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslContextManager {
    private static final Config NULL_CONFIG = new Config(null, null, null, null, null);
    static final EnumMap<ClientAuth, io.netty.handler.ssl.ClientAuth> CLIENT_AUTH_MAPPING = new EnumMap(ClientAuth.class);
    private final Supplier<SslContextFactory> supplier;
    private final boolean useWorkerPool;
    private final Map<ConfigKey, Future<Config>> configMap;
    private final Map<ConfigKey, Future<SslContextProvider>> sslContextProviderMap;

    public SslContextManager(SSLEngineOptions sslEngineOptions, int cacheMaxSize) {
        this.configMap = new LruCache<ConfigKey, Future<Config>>(cacheMaxSize);
        this.sslContextProviderMap = new LruCache<ConfigKey, Future<SslContextProvider>>(cacheMaxSize);
        this.supplier = sslEngineOptions::sslContextFactory;
        this.useWorkerPool = sslEngineOptions.getUseWorkerThread();
    }

    public static SSLEngineOptions resolveEngineOptions(SSLEngineOptions engineOptions, boolean useAlpn) {
        if (engineOptions == null && useAlpn) {
            if (JdkSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new JdkSSLEngineOptions();
            } else if (OpenSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new OpenSSLEngineOptions();
            }
        }
        if (engineOptions == null) {
            engineOptions = new JdkSSLEngineOptions();
        } else if (engineOptions instanceof OpenSSLEngineOptions && !OpenSsl.isAvailable()) {
            VertxException ex = new VertxException("OpenSSL is not available");
            Throwable cause = OpenSsl.unavailabilityCause();
            if (cause != null) {
                ex.initCause(cause);
            }
            throw ex;
        }
        if (useAlpn) {
            if (engineOptions instanceof JdkSSLEngineOptions && !JdkSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN not available for JDK SSL/TLS engine");
            }
            if (engineOptions instanceof OpenSSLEngineOptions && !OpenSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN is not available for OpenSSL SSL/TLS engine");
            }
        }
        return engineOptions;
    }

    public synchronized int sniEntrySize() {
        int size2 = 0;
        for (Future<SslContextProvider> fut : this.sslContextProviderMap.values()) {
            SslContextProvider result2 = fut.result();
            if (result2 == null) continue;
            size2 += result2.sniEntrySize();
        }
        return size2;
    }

    public SslContextManager(SSLEngineOptions sslEngineOptions) {
        this(sslEngineOptions, 256);
    }

    public Future<SslContextProvider> resolveSslContextProvider(SSLOptions options2, String endpointIdentificationAlgorithm, ClientAuth clientAuth, List<String> applicationProtocols, ContextInternal ctx) {
        return this.resolveSslContextProvider(options2, endpointIdentificationAlgorithm, clientAuth, applicationProtocols, false, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<SslContextProvider> resolveSslContextProvider(SSLOptions options2, String hostnameVerificationAlgorithm, ClientAuth clientAuth, List<String> applicationProtocols, boolean force, ContextInternal ctx) {
        Promise promise;
        ConfigKey k = new ConfigKey(options2);
        SslContextManager sslContextManager = this;
        synchronized (sslContextManager) {
            if (force) {
                this.sslContextProviderMap.remove(k);
            } else {
                Future<SslContextProvider> v = this.sslContextProviderMap.get(k);
                if (v != null) {
                    return v;
                }
            }
            promise = Promise.promise();
            this.sslContextProviderMap.put(k, promise.future());
        }
        this.buildSslContextProvider(options2, hostnameVerificationAlgorithm, clientAuth, applicationProtocols, force, ctx).onComplete(promise);
        return promise.future();
    }

    public Future<SslContextProvider> buildSslContextProvider(SSLOptions sslOptions, String hostnameVerificationAlgorithm, ClientAuth clientAuth, List<String> applicationProtocols, boolean force, ContextInternal ctx) {
        return this.buildConfig(sslOptions, force, ctx).map(config2 -> this.buildSslContextProvider(sslOptions, hostnameVerificationAlgorithm, this.supplier, clientAuth, applicationProtocols, (Config)config2));
    }

    private SslContextProvider buildSslContextProvider(SSLOptions sslOptions, String hostnameVerificationAlgorithm, Supplier<SslContextFactory> supplier, ClientAuth clientAuth, List<String> applicationProtocols, Config config2) {
        if (clientAuth == null && hostnameVerificationAlgorithm == null) {
            throw new VertxException("Missing hostname verification algorithm: you must set TCP client options host name verification algorithm");
        }
        return new SslContextProvider(this.useWorkerPool, clientAuth, hostnameVerificationAlgorithm, applicationProtocols, sslOptions.getEnabledCipherSuites(), sslOptions.getEnabledSecureTransportProtocols(), config2.keyManagerFactory, config2.keyManagerFactoryMapper, config2.trustManagerFactory, config2.trustManagerMapper, config2.crls, supplier);
    }

    private static TrustOptions trustOptionsOf(SSLOptions sslOptions) {
        ClientSSLOptions clientSSLOptions;
        if (sslOptions instanceof ClientSSLOptions && (clientSSLOptions = (ClientSSLOptions)sslOptions).isTrustAll()) {
            return TrustAllOptions.INSTANCE;
        }
        return sslOptions.getTrustOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Config> buildConfig(SSLOptions sslOptions, boolean force, ContextInternal ctx) {
        Promise promise;
        if (SslContextManager.trustOptionsOf(sslOptions) == null && sslOptions.getKeyCertOptions() == null) {
            return ctx.succeededFuture(NULL_CONFIG);
        }
        ConfigKey k = new ConfigKey(sslOptions);
        SslContextManager sslContextManager = this;
        synchronized (sslContextManager) {
            if (force) {
                this.configMap.remove(k);
            } else {
                Future<Config> fut = this.configMap.get(k);
                if (fut != null) {
                    return fut;
                }
            }
            promise = Promise.promise();
            this.configMap.put(k, promise.future());
        }
        ctx.executeBlockingInternal(() -> {
            TrustOptions trustOptions;
            KeyManagerFactory keyManagerFactory = null;
            Function<String, KeyManagerFactory> keyManagerFactoryMapper = null;
            TrustManagerFactory trustManagerFactory = null;
            Function<String, TrustManager[]> trustManagerMapper = null;
            ArrayList<CRL> crls = new ArrayList<CRL>();
            if (sslOptions.getKeyCertOptions() != null) {
                keyManagerFactory = sslOptions.getKeyCertOptions().getKeyManagerFactory(ctx.owner());
                keyManagerFactoryMapper = sslOptions.getKeyCertOptions().keyManagerFactoryMapper(ctx.owner());
            }
            if ((trustOptions = SslContextManager.trustOptionsOf(sslOptions)) != null) {
                trustManagerFactory = trustOptions.getTrustManagerFactory(ctx.owner());
                trustManagerMapper = trustOptions.trustManagerMapper(ctx.owner());
            }
            ArrayList<Buffer> tmp = new ArrayList<Buffer>();
            if (sslOptions.getCrlPaths() != null) {
                tmp.addAll(sslOptions.getCrlPaths().stream().map(path -> ctx.owner().fileResolver().resolve((String)path).getAbsolutePath()).map(ctx.owner().fileSystem()::readFileBlocking).collect(Collectors.toList()));
            }
            if (sslOptions.getCrlValues() != null) {
                tmp.addAll(sslOptions.getCrlValues());
            }
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            for (Buffer crlValue : tmp) {
                crls.addAll(certificatefactory.generateCRLs(new ByteArrayInputStream(crlValue.getBytes())));
            }
            return new Config(keyManagerFactory, trustManagerFactory, keyManagerFactoryMapper, trustManagerMapper, crls);
        }).onComplete(promise);
        return promise.future();
    }

    static {
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUIRED, io.netty.handler.ssl.ClientAuth.REQUIRE);
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUEST, io.netty.handler.ssl.ClientAuth.OPTIONAL);
        CLIENT_AUTH_MAPPING.put(ClientAuth.NONE, io.netty.handler.ssl.ClientAuth.NONE);
    }

    private static final class Config {
        private final KeyManagerFactory keyManagerFactory;
        private final TrustManagerFactory trustManagerFactory;
        private final Function<String, KeyManagerFactory> keyManagerFactoryMapper;
        private final Function<String, TrustManager[]> trustManagerMapper;
        private final List<CRL> crls;

        public Config(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory, Function<String, KeyManagerFactory> keyManagerFactoryMapper, Function<String, TrustManager[]> trustManagerMapper, List<CRL> crls) {
            this.keyManagerFactory = keyManagerFactory;
            this.trustManagerFactory = trustManagerFactory;
            this.keyManagerFactoryMapper = keyManagerFactoryMapper;
            this.trustManagerMapper = trustManagerMapper;
            this.crls = crls;
        }
    }

    private static final class ConfigKey {
        private final KeyCertOptions keyCertOptions;
        private final TrustOptions trustOptions;
        private final List<Buffer> crlValues;

        public ConfigKey(SSLOptions options2) {
            this(options2.getKeyCertOptions(), SslContextManager.trustOptionsOf(options2), options2.getCrlValues());
        }

        public ConfigKey(KeyCertOptions keyCertOptions, TrustOptions trustOptions, List<Buffer> crlValues) {
            this.keyCertOptions = keyCertOptions;
            this.trustOptions = trustOptions;
            this.crlValues = crlValues != null ? new ArrayList<Buffer>(crlValues) : null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ConfigKey) {
                ConfigKey that = (ConfigKey)obj;
                return Objects.equals(this.keyCertOptions, that.keyCertOptions) && Objects.equals(this.trustOptions, that.trustOptions) && Objects.equals(this.crlValues, that.crlValues);
            }
            return false;
        }

        public int hashCode() {
            int hashCode2 = Objects.hashCode(this.keyCertOptions);
            hashCode2 = 31 * hashCode2 + Objects.hashCode(this.trustOptions);
            hashCode2 = 31 * hashCode2 + Objects.hashCode(this.crlValues);
            return hashCode2;
        }
    }

    private static class LruCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public LruCache(int maxSize) {
            if (maxSize < 1) {
                throw new UnsupportedOperationException();
            }
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

