/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.threadchecker;

import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.threadchecker.BlockedThreadEvent;
import io.vertx.core.internal.threadchecker.ThreadInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

public class BlockedThreadChecker {
    public static final String LOGGER_NAME = "io.vertx.core.impl.BlockedThreadChecker";
    private static final Logger log = LoggerFactory.getLogger("io.vertx.core.impl.BlockedThreadChecker");
    private final Map<Thread, ThreadInfo> threads = new WeakHashMap<Thread, ThreadInfo>();
    private final Timer timer = new Timer("vertx-blocked-thread-checker", true);
    private Handler<BlockedThreadEvent> blockedThreadHandler = BlockedThreadChecker::defaultBlockedThreadHandler;

    public BlockedThreadChecker(long interval, TimeUnit intervalUnit, final long warningExceptionTime, final TimeUnit warningExceptionTimeUnit) {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Handler<BlockedThreadEvent> handler;
                ArrayList<BlockedThreadEvent> events = new ArrayList<BlockedThreadEvent>();
                BlockedThreadChecker blockedThreadChecker = BlockedThreadChecker.this;
                synchronized (blockedThreadChecker) {
                    handler = BlockedThreadChecker.this.blockedThreadHandler;
                    long now = System.nanoTime();
                    for (Map.Entry<Thread, ThreadInfo> entry : BlockedThreadChecker.this.threads.entrySet()) {
                        ThreadInfo task = entry.getValue();
                        long execStart = task.startTime;
                        long dur = now - execStart;
                        long timeLimit = task.maxExecTime;
                        TimeUnit maxExecTimeUnit = task.maxExecTimeUnit;
                        long maxExecTimeInNanos = TimeUnit.NANOSECONDS.convert(timeLimit, maxExecTimeUnit);
                        long warningExceptionTimeInNanos = TimeUnit.NANOSECONDS.convert(warningExceptionTime, warningExceptionTimeUnit);
                        if (execStart == 0L || dur < maxExecTimeInNanos) continue;
                        events.add(new BlockedThreadEvent(entry.getKey(), dur, maxExecTimeInNanos, warningExceptionTimeInNanos));
                    }
                }
                events.forEach(handler::handle);
            }
        }, intervalUnit.toMillis(interval), intervalUnit.toMillis(interval));
    }

    public synchronized void setThreadBlockedHandler(Handler<BlockedThreadEvent> handler) {
        this.blockedThreadHandler = handler == null ? BlockedThreadChecker::defaultBlockedThreadHandler : handler;
    }

    public synchronized void registerThread(Thread thread2, ThreadInfo checked) {
        this.threads.put(thread2, checked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.timer.cancel();
        BlockedThreadChecker blockedThreadChecker = this;
        synchronized (blockedThreadChecker) {
            this.threads.clear();
        }
    }

    private static void defaultBlockedThreadHandler(BlockedThreadEvent bte) {
        String message = "Thread " + bte.thread().getName() + " has been blocked for " + bte.duration() / 1000000L + " ms, time limit is " + bte.maxExecTime() / 1000000L + " ms";
        if (bte.duration() <= bte.warningExceptionTime()) {
            log.warn(message);
        } else {
            VertxException stackTrace = new VertxException("Thread blocked");
            stackTrace.setStackTrace(bte.thread().getStackTrace());
            log.warn(message, stackTrace);
        }
    }
}

