/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.pool;

import io.vertx.core.internal.pool.Executor;
import io.vertx.core.internal.pool.Task;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SemaphoreExecutor<S>
implements Executor<S> {
    private final Lock lock = new ReentrantLock();
    private final S state;

    public SemaphoreExecutor(S state2) {
        this.state = state2;
    }

    @Override
    public void submit(Executor.Action<S> action) {
        this.lock.lock();
        Task post = null;
        try {
            post = action.execute(this.state);
        }
        finally {
            this.lock.unlock();
            while (post != null) {
                post.run();
                post = post.next();
            }
        }
    }
}

